/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.context.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.mylar.context.core.IDegreeOfInterest;
import org.eclipse.mylar.internal.context.core.MylarContext;
import org.eclipse.mylar.internal.context.core.ScalingFactors;
import org.eclipse.mylar.monitor.core.InteractionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DegreeOfInterest
implements IDegreeOfInterest {
    private List<InteractionEvent> events = new ArrayList<InteractionEvent>();
    private Map<InteractionEvent.Kind, InteractionEvent> collapsedEvents = new HashMap<InteractionEvent.Kind, InteractionEvent>();
    protected ScalingFactors scaling;
    private float edits = 0.0f;
    private float selections = 0.0f;
    private float commands = 0.0f;
    private float predictedBias = 0.0f;
    private float propagatedBias = 0.0f;
    private float manipulationBias = 0.0f;
    private MylarContext context;
    private int eventCountOnCreation;

    public DegreeOfInterest(MylarContext context, ScalingFactors scaling) {
        this.context = context;
        this.eventCountOnCreation = context.getUserEventCount();
        this.scaling = scaling;
    }

    public void addEvent(InteractionEvent event) {
        this.events.add(0, event);
        InteractionEvent last = this.collapsedEvents.get(event.getKind());
        if (last != null) {
            InteractionEvent aggregateEvent = new InteractionEvent(event.getKind(), event.getStructureKind(), event.getStructureHandle(), event.getOriginId(), event.getNavigation(), event.getDelta(), last.getInterestContribution() + event.getInterestContribution(), last.getDate(), event.getEndDate());
            this.collapsedEvents.put(event.getKind(), aggregateEvent);
        } else {
            this.collapsedEvents.put(event.getKind(), event);
        }
        this.updateEventState(event);
    }

    private void updateEventState(InteractionEvent event) {
        switch (event.getKind()) {
            case EDIT: {
                this.edits += event.getInterestContribution();
                break;
            }
            case SELECTION: {
                this.selections += event.getInterestContribution();
                break;
            }
            case COMMAND: {
                this.commands += event.getInterestContribution();
                break;
            }
            case PREDICTION: {
                this.predictedBias += event.getInterestContribution();
                break;
            }
            case PROPAGATION: {
                this.propagatedBias += event.getInterestContribution();
                break;
            }
            case MANIPULATION: {
                this.manipulationBias += event.getInterestContribution();
            }
        }
    }

    @Override
    public float getValue() {
        float value = this.getEncodedValue();
        value += this.predictedBias;
        return value += this.propagatedBias;
    }

    @Override
    public float getEncodedValue() {
        float value = 0.0f;
        value += this.selections * this.scaling.get(InteractionEvent.Kind.SELECTION).getValue();
        value += this.edits * this.scaling.get(InteractionEvent.Kind.EDIT).getValue();
        value += this.commands * this.scaling.get(InteractionEvent.Kind.COMMAND).getValue();
        value += this.manipulationBias;
        return value -= this.getDecayValue();
    }

    @Override
    public float getDecayValue() {
        if (this.context != null) {
            return (float)(this.context.getUserEventCount() - this.eventCountOnCreation) * this.scaling.getDecay().getValue();
        }
        return 0.0f;
    }

    @Override
    public boolean isPropagated() {
        float value = this.selections * this.scaling.get(InteractionEvent.Kind.SELECTION).getValue() + this.edits * this.scaling.get(InteractionEvent.Kind.EDIT).getValue();
        return value <= 0.0f && this.propagatedBias > 0.0f;
    }

    @Override
    public boolean isPredicted() {
        return this.getEncodedValue() <= 0.0f && this.predictedBias > 0.0f;
    }

    @Override
    public boolean isLandmark() {
        return this.getValue() >= this.scaling.getLandmark();
    }

    @Override
    public boolean isInteresting() {
        return this.getValue() > this.scaling.getInteresting();
    }

    public String toString() {
        return "(selections: " + this.selections + ", edits: " + this.edits + ", commands: " + this.commands + ", predicted: " + this.predictedBias + ", propagated: " + this.propagatedBias + ", manipulation: " + this.manipulationBias + ")";
    }

    @Override
    public List<InteractionEvent> getEvents() {
        return this.events;
    }

    public List<InteractionEvent> getCollapsedEvents() {
        ArrayList<InteractionEvent> allCollapsed = new ArrayList<InteractionEvent>();
        allCollapsed.addAll(this.collapsedEvents.values());
        if (!allCollapsed.isEmpty()) {
            allCollapsed.add(0, new InteractionEvent(InteractionEvent.Kind.MANIPULATION, ((InteractionEvent)allCollapsed.get(0)).getStructureKind(), ((InteractionEvent)allCollapsed.get(0)).getStructureHandle(), "org.eclipse.mylar.core.model.interest.decay", -this.getDecayValue()));
        }
        return allCollapsed;
    }
}

