/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.context.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.mylar.context.core.IMylarContext;
import org.eclipse.mylar.context.core.IMylarElement;
import org.eclipse.mylar.internal.context.core.DegreeOfInterest;
import org.eclipse.mylar.internal.context.core.MylarContextElement;
import org.eclipse.mylar.internal.context.core.MylarContextRelation;
import org.eclipse.mylar.internal.context.core.ScalingFactors;
import org.eclipse.mylar.monitor.core.InteractionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MylarContext
implements IMylarContext {
    private String handleIdentifier;
    private List<InteractionEvent> interactionHistory = new ArrayList<InteractionEvent>();
    protected ConcurrentHashMap<String, MylarContextElement> elementMap;
    protected Map<String, IMylarElement> landmarkMap;
    protected MylarContextElement activeNode = null;
    private InteractionEvent lastEdgeEvent = null;
    private MylarContextElement lastEdgeNode = null;
    private int numUserEvents = 0;
    protected ScalingFactors scalingFactors;

    void parseInteractionHistory() {
        this.elementMap = new ConcurrentHashMap();
        this.landmarkMap = new HashMap<String, IMylarElement>();
        for (InteractionEvent event : this.interactionHistory) {
            this.parseInteractionEvent(event);
        }
        this.updateLandmarks();
        this.activeNode = this.lastEdgeNode;
    }

    public MylarContext(String id, ScalingFactors scaling) {
        this.handleIdentifier = id;
        this.scalingFactors = scaling;
        this.parseInteractionHistory();
    }

    public IMylarElement parseEvent(InteractionEvent event) {
        this.interactionHistory.add(event);
        return this.parseInteractionEvent(event);
    }

    private IMylarElement parseInteractionEvent(InteractionEvent event) {
        IMylarElement navigationSource;
        MylarContextElement node;
        if (event.getStructureHandle() == null) {
            return null;
        }
        if (event.getKind().isUserEvent()) {
            ++this.numUserEvents;
        }
        if ((node = this.elementMap.get(event.getStructureHandle())) == null) {
            node = new MylarContextElement(event.getStructureKind(), event.getStructureHandle(), this);
            this.elementMap.put(event.getStructureHandle(), node);
        }
        if (event.getNavigation() != null && !event.getNavigation().equals("null") && this.lastEdgeEvent != null && this.lastEdgeNode != null && this.lastEdgeEvent.getStructureHandle() != null && event.getKind() != InteractionEvent.Kind.PROPAGATION && event.getKind() != InteractionEvent.Kind.PREDICTION && (navigationSource = (IMylarElement)this.elementMap.get(this.lastEdgeEvent.getStructureHandle())) != null) {
            MylarContextRelation edge = this.lastEdgeNode.getRelation(event.getStructureHandle());
            if (edge == null) {
                edge = new MylarContextRelation(event.getStructureKind(), event.getNavigation(), this.lastEdgeNode, node, this);
                this.lastEdgeNode.addEdge(edge);
            }
            DegreeOfInterest doi = (DegreeOfInterest)edge.getInterest();
            doi.addEvent(event);
        }
        DegreeOfInterest doi = (DegreeOfInterest)node.getInterest();
        doi.addEvent(event);
        if (doi.isLandmark()) {
            this.landmarkMap.put(node.getHandleIdentifier(), node);
        } else {
            this.landmarkMap.remove(node.getHandleIdentifier());
        }
        if (event.getKind().isUserEvent()) {
            this.lastEdgeEvent = event;
            this.lastEdgeNode = node;
            this.activeNode = node;
        }
        return node;
    }

    private void updateLandmarks() {
        for (MylarContextElement node : this.elementMap.values()) {
            if (!node.getInterest().isLandmark()) continue;
            this.landmarkMap.put(node.getHandleIdentifier(), node);
        }
    }

    @Override
    public IMylarElement get(String elementHandle) {
        if (elementHandle == null) {
            return null;
        }
        return this.elementMap.get(elementHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IMylarElement> getInteresting() {
        ArrayList<IMylarElement> elements = new ArrayList<IMylarElement>();
        ConcurrentHashMap<String, MylarContextElement> concurrentHashMap = this.elementMap;
        synchronized (concurrentHashMap) {
            for (String key : this.elementMap.keySet()) {
                MylarContextElement info = this.elementMap.get(key);
                if (info == null || !info.getInterest().isInteresting()) continue;
                elements.add(info);
            }
        }
        return elements;
    }

    public List<IMylarElement> getLandmarkMap() {
        return Collections.unmodifiableList(new ArrayList<IMylarElement>(this.landmarkMap.values()));
    }

    @Override
    public void updateElementHandle(IMylarElement element, String newHandle) {
        MylarContextElement currElement = this.elementMap.remove(element.getHandleIdentifier());
        if (currElement != null) {
            currElement.setHandleIdentifier(newHandle);
            this.elementMap.put(newHandle, currElement);
        }
    }

    @Override
    public IMylarElement getActiveNode() {
        return this.activeNode;
    }

    @Override
    public void delete(IMylarElement node) {
        this.landmarkMap.remove(node.getHandleIdentifier());
        this.elementMap.remove(node.getHandleIdentifier());
    }

    @Override
    public synchronized List<IMylarElement> getAllElements() {
        return new ArrayList<IMylarElement>(this.elementMap.values());
    }

    @Override
    public String getHandleIdentifier() {
        return this.handleIdentifier;
    }

    public String toString() {
        return this.handleIdentifier;
    }

    public void reset() {
        this.interactionHistory.clear();
        this.elementMap.clear();
        this.interactionHistory.clear();
        this.landmarkMap.clear();
        this.activeNode = null;
    }

    public int getUserEventCount() {
        return this.numUserEvents;
    }

    @Override
    public List<InteractionEvent> getInteractionHistory() {
        return this.interactionHistory;
    }

    public void collapse() {
        ArrayList<InteractionEvent> collapsedHistory = new ArrayList<InteractionEvent>();
        for (MylarContextElement node : this.elementMap.values()) {
            if (node.equals(this.activeNode)) continue;
            this.collapseNode(collapsedHistory, node);
        }
        this.collapseNode(collapsedHistory, this.activeNode);
        this.interactionHistory.clear();
        this.interactionHistory.addAll(collapsedHistory);
    }

    private void collapseNode(List<InteractionEvent> collapsedHistory, MylarContextElement node) {
        if (node != null) {
            collapsedHistory.addAll(((DegreeOfInterest)node.getInterest()).getCollapsedEvents());
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof MylarContext)) {
            return false;
        }
        MylarContext context = (MylarContext)object;
        return (this.handleIdentifier == null ? context.handleIdentifier == null : this.handleIdentifier.equals(context.handleIdentifier)) && (this.interactionHistory == null ? context.interactionHistory == null : this.interactionHistory.equals(context.interactionHistory)) && (this.elementMap == null ? context.elementMap == null : this.elementMap.equals(context.elementMap)) && (this.activeNode == null ? context.activeNode == null : this.activeNode.equals(context.activeNode)) && (this.landmarkMap == null ? context.landmarkMap == null : this.landmarkMap.equals(context.landmarkMap)) && (this.scalingFactors == null ? context.scalingFactors == null : this.scalingFactors.equals(context.scalingFactors)) && this.numUserEvents == context.numUserEvents;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.handleIdentifier != null) {
            hashCode += this.handleIdentifier.hashCode();
        }
        if (this.interactionHistory != null) {
            hashCode += this.interactionHistory.hashCode();
        }
        if (this.elementMap != null) {
            hashCode += this.elementMap.hashCode();
        }
        if (this.activeNode != null) {
            hashCode += this.activeNode.hashCode();
        }
        if (this.landmarkMap != null) {
            hashCode += this.landmarkMap.hashCode();
        }
        if (this.scalingFactors != null) {
            hashCode += this.scalingFactors.hashCode();
        }
        return hashCode += 37 * this.numUserEvents;
    }

    public ScalingFactors getScalingFactors() {
        return this.scalingFactors;
    }
}

