/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.context.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.mylar.context.core.IDegreeOfInterest;
import org.eclipse.mylar.context.core.IMylarElement;
import org.eclipse.mylar.context.core.IMylarRelation;
import org.eclipse.mylar.internal.context.core.DegreeOfInterest;
import org.eclipse.mylar.internal.context.core.MylarContext;
import org.eclipse.mylar.internal.context.core.MylarContextRelation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MylarContextElement
implements IMylarElement {
    private String handle;
    private String kind;
    private DegreeOfInterest interest;
    private MylarContext context;
    private Map<String, MylarContextRelation> edges = new HashMap<String, MylarContextRelation>();

    public MylarContextElement(String kind, String elementHandle, MylarContext context) {
        if (elementHandle == null) {
            throw new RuntimeException("malformed context: null handle");
        }
        this.interest = new DegreeOfInterest(context, context.getScalingFactors());
        this.handle = elementHandle;
        this.kind = kind;
        this.context = context;
    }

    @Override
    public String getHandleIdentifier() {
        return this.handle;
    }

    @Override
    public void setHandleIdentifier(String handle) {
        this.handle = handle;
    }

    @Override
    public String getContentType() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    @Override
    public Collection<MylarContextRelation> getRelations() {
        return this.edges.values();
    }

    @Override
    public MylarContextRelation getRelation(String targetHandle) {
        return this.edges.get(targetHandle);
    }

    public void addEdge(MylarContextRelation edge) {
        this.edges.put(edge.getTarget().getHandleIdentifier(), edge);
    }

    @Override
    public void clearRelations() {
        this.edges.clear();
    }

    void removeEdge(IMylarRelation edge) {
        this.edges.remove(edge.getTarget().getHandleIdentifier());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getHandleIdentifier() == null) {
            return false;
        }
        if (obj instanceof MylarContextElement) {
            MylarContextElement node = (MylarContextElement)obj;
            return this.getHandleIdentifier().equals(node.getHandleIdentifier());
        }
        return false;
    }

    public int hashCode() {
        if (this.handle != null) {
            return this.handle.hashCode();
        }
        return super.hashCode();
    }

    @Override
    public IDegreeOfInterest getInterest() {
        return this.interest;
    }

    @Override
    public MylarContext getContext() {
        return this.context;
    }

    public String toString() {
        return this.handle;
    }
}

