/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.context.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.mylar.context.core.IContextReader;
import org.eclipse.mylar.context.core.IContextWriter;
import org.eclipse.mylar.core.MylarStatusHandler;
import org.eclipse.mylar.internal.context.core.MylarContext;
import org.eclipse.mylar.internal.context.core.SaxContextReader;
import org.eclipse.mylar.internal.context.core.SaxContextWriter;

public class MylarContextExternalizer {
    private IContextReader reader = new SaxContextReader();
    private IContextWriter writer = new SaxContextWriter();
    public static final String ELMNT_INTERACTION_HISTORY_OLD = "interactionEvent";
    public static final String ELMNT_INTERACTION_HISTORY = "InteractionHistory";
    public static final String ATR_STRUCTURE_KIND = "StructureKind";
    public static final String ATR_STRUCTURE_HANDLE = "StructureHandle";
    public static final String ATR_START_DATE = "StartDate";
    public static final String ATR_ORIGIN_ID = "OriginId";
    public static final String ATR_NAVIGATION = "Navigation";
    public static final String ATR_KIND = "Kind";
    public static final String ATR_INTEREST = "Interest";
    public static final String ATR_DELTA = "Delta";
    public static final String ATR_END_DATE = "EndDate";
    public static final String ATR_ID = "Id";
    public static final String ATR_VERSION = "Version";
    private static final String DATE_FORMAT_STRING = "yyyy-MM-dd HH:mm:ss.S z";
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S z", Locale.ENGLISH);

    public void writeContextToXml(MylarContext context, File file) {
        if (context.getInteractionHistory().isEmpty()) {
            return;
        }
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            String handleIdentifier = context.getHandleIdentifier();
            String encoded = URLEncoder.encode(handleIdentifier, "UTF-8");
            ZipOutputStream outputStream = new ZipOutputStream(new FileOutputStream(file));
            ZipEntry zipEntry = new ZipEntry(String.valueOf(encoded) + ".xml");
            outputStream.putNextEntry(zipEntry);
            outputStream.setMethod(8);
            this.writer.setOutputStream(outputStream);
            this.writer.writeContextToStream(context);
            outputStream.closeEntry();
            outputStream.flush();
            outputStream.close();
        }
        catch (IOException e) {
            MylarStatusHandler.fail((Throwable)e, (String)("Could not write: " + file.getAbsolutePath()), (boolean)true);
        }
    }

    public MylarContext readContextFromXML(String handleIdentifier, File file) {
        block3: {
            try {
                if (file.exists()) break block3;
                return null;
            }
            catch (Exception e) {
                MylarStatusHandler.fail((Throwable)e, (String)("Could not read: " + file.getAbsolutePath()), (boolean)true);
                return null;
            }
        }
        return this.reader.readContext(handleIdentifier, file);
    }

    public IContextReader getReader() {
        return this.reader;
    }

    public void setReader(IContextReader reader) {
        this.reader = reader;
    }

    public IContextWriter getWriter() {
        return this.writer;
    }

    public void setWriter(IContextWriter writer) {
        this.writer = writer;
    }
}

