/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.context.core;

import java.text.ParseException;
import java.util.Date;
import org.eclipse.mylar.internal.context.core.ContextManager;
import org.eclipse.mylar.internal.context.core.MylarContext;
import org.eclipse.mylar.internal.context.core.MylarContextExternalizer;
import org.eclipse.mylar.internal.core.util.XmlStringConverter;
import org.eclipse.mylar.monitor.core.InteractionEvent;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SaxContextContentHandler
extends DefaultHandler {
    private static final int EXPECTING_ROOT = 0;
    private static final int EXPECTING_EVENT = 1;
    private int state = 0;
    private MylarContext context;
    private String contextHandleIdentifier;
    static final String ATTRIBUTE_INTERACTION_EVENT = "InteractionEvent";

    public SaxContextContentHandler(String contextHandleIdentifier) {
        this.contextHandleIdentifier = contextHandleIdentifier;
    }

    public MylarContext getContext() {
        return this.context;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        switch (this.state) {
            case 0: {
                this.context = new MylarContext(this.contextHandleIdentifier, ContextManager.getScalingFactors());
                this.state = 1;
                break;
            }
            case 1: {
                try {
                    InteractionEvent ie = SaxContextContentHandler.createEventFromAttributes(attributes);
                    this.context.parseEvent(ie);
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static InteractionEvent createEventFromAttributes(Attributes attributes) throws ParseException {
        String delta = XmlStringConverter.convertXmlToString((String)attributes.getValue("Delta"));
        String endDate = attributes.getValue("EndDate");
        String interest = attributes.getValue("Interest");
        String kind = attributes.getValue("Kind");
        String navigation = XmlStringConverter.convertXmlToString((String)attributes.getValue("Navigation"));
        String originId = XmlStringConverter.convertXmlToString((String)attributes.getValue("OriginId"));
        String startDate = attributes.getValue("StartDate");
        String structureHandle = XmlStringConverter.convertXmlToString((String)attributes.getValue("StructureHandle"));
        String structureKind = XmlStringConverter.convertXmlToString((String)attributes.getValue("StructureKind"));
        Date dStartDate = MylarContextExternalizer.DATE_FORMAT.parse(startDate);
        Date dEndDate = MylarContextExternalizer.DATE_FORMAT.parse(endDate);
        float iInterest = Float.parseFloat(interest);
        InteractionEvent ie = new InteractionEvent(InteractionEvent.Kind.fromString((String)kind), structureKind, structureHandle, originId, navigation, delta, iInterest, dStartDate, dEndDate);
        return ie;
    }
}

