/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.context.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.ZipInputStream;
import org.eclipse.mylar.context.core.IContextReader;
import org.eclipse.mylar.core.MylarStatusHandler;
import org.eclipse.mylar.internal.context.core.MylarContext;
import org.eclipse.mylar.internal.context.core.SaxContextContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SaxContextReader
implements IContextReader {
    public MylarContext readContext(String handleIdentifier, File file) {
        if (!file.exists()) {
            return null;
        }
        ZipInputStream inputStream = null;
        try {
            inputStream = new ZipInputStream(new FileInputStream(file));
            inputStream.getNextEntry();
            SaxContextContentHandler contentHandler = new SaxContextContentHandler(handleIdentifier);
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(contentHandler);
            reader.parse(new InputSource(inputStream));
            MylarContext mylarContext = contentHandler.getContext();
            return mylarContext;
        }
        catch (Throwable throwable) {
            file.renameTo(new File(String.valueOf(file.getAbsolutePath()) + "-save"));
            return null;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    MylarStatusHandler.fail((Throwable)e, (String)"Failed to close context input stream.", (boolean)false);
                }
            }
        }
    }
}

