/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.context.core;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.mylar.context.core.IContextWriter;
import org.eclipse.mylar.core.MylarStatusHandler;
import org.eclipse.mylar.internal.context.core.MylarContext;
import org.eclipse.mylar.internal.context.core.MylarContextExternalizer;
import org.eclipse.mylar.internal.core.util.XmlStringConverter;
import org.eclipse.mylar.monitor.core.InteractionEvent;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class SaxContextWriter
implements IContextWriter {
    private OutputStream outputStream;

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public void writeContextToStream(MylarContext context) throws IOException {
        if (this.outputStream == null) {
            IOException ioe = new IOException("OutputStream not set");
            throw ioe;
        }
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(new SAXSource(new SaxWriter(), new MylarContextInputSource(context)), new StreamResult(this.outputStream));
        }
        catch (TransformerException e) {
            MylarStatusHandler.fail((Throwable)e, (String)"could not write context", (boolean)false);
            throw new IOException(e.getMessage());
        }
    }

    public static Attributes createEventAttributes(InteractionEvent ie) {
        AttributesImpl ieAttributes = new AttributesImpl();
        ieAttributes.addAttribute("", "Delta", "Delta", "", XmlStringConverter.convertToXmlString((String)ie.getDelta()));
        ieAttributes.addAttribute("", "EndDate", "EndDate", "", MylarContextExternalizer.DATE_FORMAT.format(ie.getEndDate()));
        ieAttributes.addAttribute("", "Interest", "Interest", "", Float.toString(ie.getInterestContribution()));
        ieAttributes.addAttribute("", "Kind", "Kind", "", ie.getKind().toString());
        ieAttributes.addAttribute("", "Navigation", "Navigation", "", XmlStringConverter.convertToXmlString((String)ie.getNavigation()));
        ieAttributes.addAttribute("", "OriginId", "OriginId", "", XmlStringConverter.convertToXmlString((String)ie.getOriginId()));
        ieAttributes.addAttribute("", "StartDate", "StartDate", "", MylarContextExternalizer.DATE_FORMAT.format(ie.getDate()));
        ieAttributes.addAttribute("", "StructureHandle", "StructureHandle", "", XmlStringConverter.convertToXmlString((String)ie.getStructureHandle()));
        ieAttributes.addAttribute("", "StructureKind", "StructureKind", "", XmlStringConverter.convertToXmlString((String)ie.getStructureKind()));
        return ieAttributes;
    }

    private static class MylarContextInputSource
    extends InputSource {
        private MylarContext context;

        public MylarContextInputSource(MylarContext context) {
            this.context = context;
        }

        public MylarContext getContext() {
            return this.context;
        }

        public void setContext(MylarContext context) {
            this.context = context;
        }
    }

    private static class SaxWriter
    implements XMLReader {
        private ContentHandler handler;
        private ErrorHandler errorHandler;

        private SaxWriter() {
        }

        public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
            return false;
        }

        public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        }

        public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
            return null;
        }

        public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        }

        public void setEntityResolver(EntityResolver resolver) {
        }

        public EntityResolver getEntityResolver() {
            return null;
        }

        public void setDTDHandler(DTDHandler handler) {
        }

        public DTDHandler getDTDHandler() {
            return null;
        }

        public void setContentHandler(ContentHandler handler) {
            this.handler = handler;
        }

        public ContentHandler getContentHandler() {
            return this.handler;
        }

        public void setErrorHandler(ErrorHandler handler) {
            this.errorHandler = handler;
        }

        public ErrorHandler getErrorHandler() {
            return this.errorHandler;
        }

        public void parse(InputSource input) throws IOException, SAXException {
            if (!(input instanceof MylarContextInputSource)) {
                throw new SAXException("Can only parse writable input sources");
            }
            MylarContext context = ((MylarContextInputSource)input).getContext();
            this.handler.startDocument();
            AttributesImpl rootAttributes = new AttributesImpl();
            rootAttributes.addAttribute("", "Id", "Id", "", context.getHandleIdentifier());
            rootAttributes.addAttribute("", "Version", "Version", "", "1");
            this.handler.startElement("", "InteractionHistory", "InteractionHistory", rootAttributes);
            for (InteractionEvent ie : new ArrayList<InteractionEvent>(context.getInteractionHistory())) {
                Attributes ieAttributes = SaxContextWriter.createEventAttributes(ie);
                this.handler.startElement("", "InteractionEvent", "InteractionEvent", ieAttributes);
                this.handler.endElement("", "InteractionEvent", "InteractionEvent");
            }
            this.handler.endElement("", "InteractionHistory", "InteractionHistory");
            this.handler.endDocument();
        }

        public void parse(String systemId) throws IOException, SAXException {
            throw new SAXException("Can only parse writable input sources");
        }
    }
}

