/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.context.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.mylar.internal.context.core.ScalingFactor;
import org.eclipse.mylar.monitor.core.InteractionEvent;

public class ScalingFactors {
    private ScalingFactor defaultDecay = new ScalingFactor("decay", 0.017f);
    private ScalingFactor defaultEdit = new ScalingFactor("edit", 0.7f);
    private ScalingFactor defaultPurge = new ScalingFactor("edit", -10.0f);
    private float landmark = 30.0f;
    private float interesting = 0.0f;
    private int degreeOfSeparation = 2;
    private int degreeOfSeparationScale = 3;
    private float errorInterest = 0.3f;
    private int maxNumInterestingErrors = 20;
    private Map<InteractionEvent.Kind, ScalingFactor> factors = new HashMap<InteractionEvent.Kind, ScalingFactor>();
    private static final ScalingFactor DEFAULT_SCALING_FACTOR = new ScalingFactor("<default>", 1.0f);

    public ScalingFactors() {
        this.factors.put(InteractionEvent.Kind.EDIT, this.defaultEdit);
    }

    public ScalingFactor get(InteractionEvent.Kind kind) {
        ScalingFactor factor = this.factors.get(kind);
        if (factor != null) {
            return factor;
        }
        return DEFAULT_SCALING_FACTOR;
    }

    public ScalingFactor getDecay() {
        return this.defaultDecay;
    }

    public void setDecay(ScalingFactor decay) {
        this.defaultDecay = decay;
    }

    public float getInteresting() {
        return this.interesting;
    }

    public void setInteresting(float interesting) {
        this.interesting = interesting;
    }

    public float getLandmark() {
        return this.landmark;
    }

    public void setLandmark(float landmark) {
        this.landmark = landmark;
    }

    public int getDegreeOfSeparation() {
        return this.degreeOfSeparation;
    }

    public void setDegreeOfSeparation(int degreeOfSeparation) {
        this.degreeOfSeparation = degreeOfSeparation;
    }

    public int getDegreeOfSeparationScale() {
        return this.degreeOfSeparationScale;
    }

    public void setDegreeOfSeparationScale(int degreeOfSeparationScale) {
        this.degreeOfSeparationScale = degreeOfSeparationScale;
    }

    @Deprecated
    public float getParentPropagationIncrement(int level) {
        return 1.0f / (float)(level * level);
    }

    public float getErrorInterest() {
        return this.errorInterest;
    }

    public int getMaxNumInterestingErrors() {
        return this.maxNumInterestingErrors;
    }

    public ScalingFactor getPurge() {
        return this.defaultPurge;
    }
}

