/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.context.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mylar.context.core.AbstractRelationProvider;
import org.eclipse.mylar.context.core.ContextCorePlugin;
import org.eclipse.mylar.context.core.IMylarContextListener;
import org.eclipse.mylar.context.core.IMylarElement;
import org.eclipse.mylar.context.core.IMylarRelation;
import org.eclipse.mylar.context.ui.AbstractContextUiBridge;
import org.eclipse.mylar.core.MylarStatusHandler;
import org.eclipse.mylar.internal.context.ui.AbstractContextLabelProvider;
import org.eclipse.mylar.internal.context.ui.ActiveSearchViewTracker;
import org.eclipse.mylar.internal.context.ui.ColorMap;
import org.eclipse.mylar.internal.context.ui.ContentOutlineManager;
import org.eclipse.mylar.internal.context.ui.ContextPerspectiveManager;
import org.eclipse.mylar.internal.context.ui.FocusedViewerManager;
import org.eclipse.mylar.internal.context.ui.Highlighter;
import org.eclipse.mylar.internal.context.ui.HighlighterList;
import org.eclipse.mylar.internal.context.ui.MylarWorkingSetManager;
import org.eclipse.mylar.internal.context.ui.actions.ContextRetrieveAction;
import org.eclipse.mylar.internal.tasks.ui.ITaskHighlighter;
import org.eclipse.mylar.monitor.ui.MylarMonitorUiPlugin;
import org.eclipse.mylar.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylar.tasks.core.AbstractRepositoryTask;
import org.eclipse.mylar.tasks.core.DateRangeContainer;
import org.eclipse.mylar.tasks.core.ITask;
import org.eclipse.mylar.tasks.core.ITaskActivityListener;
import org.eclipse.mylar.tasks.core.TaskRepository;
import org.eclipse.mylar.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextUiPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.mylar.ui";
    private Map<String, AbstractContextUiBridge> bridges = new HashMap<String, AbstractContextUiBridge>();
    private Map<String, ILabelProvider> contextLabelProviders = new HashMap<String, ILabelProvider>();
    private static ContextUiPlugin INSTANCE;
    private ResourceBundle resourceBundle;
    private boolean decorateInterestMode = false;
    private HighlighterList highlighters = null;
    private Highlighter intersectionHighlighter;
    private ColorMap colorMap = new ColorMap();
    private FocusedViewerManager viewerManager;
    private ContextPerspectiveManager perspectiveManager = new ContextPerspectiveManager();
    private ContentOutlineManager contentOutlineManager = new ContentOutlineManager();
    private List<MylarWorkingSetManager> workingSetUpdaters = null;
    private ActiveSearchViewTracker activeSearchViewTracker = new ActiveSearchViewTracker();
    private Map<AbstractContextUiBridge, ImageDescriptor> activeSearchIcons = new HashMap<AbstractContextUiBridge, ImageDescriptor>();
    private Map<AbstractContextUiBridge, String> activeSearchLabels = new HashMap<AbstractContextUiBridge, String>();
    private Map<String, Set<Class<?>>> preservedFilterClasses = new HashMap();
    private Map<String, Set<String>> preservedFilterIds = new HashMap<String, Set<String>>();
    private final ITaskHighlighter DEFAULT_HIGHLIGHTER = new ITaskHighlighter(){

        public Color getHighlightColor(ITask task) {
            Highlighter highlighter = ContextUiPlugin.this.getHighlighterForContextId(task.getHandleIdentifier());
            if (highlighter != null) {
                return highlighter.getHighlightColor();
            }
            return null;
        }
    };
    private static final AbstractContextLabelProvider DEFAULT_LABEL_PROVIDER;
    private static final AbstractContextUiBridge DEFAULT_UI_BRIDGE;
    private static final ITaskActivityListener TASK_ACTIVATION_LISTENER;

    static {
        DEFAULT_LABEL_PROVIDER = new AbstractContextLabelProvider(){

            protected Image getImage(IMylarElement node) {
                return null;
            }

            protected Image getImage(IMylarRelation edge) {
                return null;
            }

            protected String getText(IMylarElement node) {
                return "? " + node;
            }

            protected String getText(IMylarRelation edge) {
                return "? " + edge;
            }

            protected Image getImageForObject(Object object) {
                return null;
            }

            protected String getTextForObject(Object node) {
                return "? " + node;
            }
        };
        DEFAULT_UI_BRIDGE = new AbstractContextUiBridge(){

            @Override
            public void open(IMylarElement node) {
            }

            @Override
            public void close(IMylarElement node) {
            }

            @Override
            public boolean acceptsEditor(IEditorPart editorPart) {
                return false;
            }

            @Override
            public List<TreeViewer> getContentOutlineViewers(IEditorPart editor) {
                return Collections.emptyList();
            }

            @Override
            public Object getObjectForTextSelection(TextSelection selection, IEditorPart editor) {
                return null;
            }

            @Override
            public IMylarElement getElement(IEditorInput input) {
                return null;
            }

            @Override
            public String getContentType() {
                return null;
            }
        };
        TASK_ACTIVATION_LISTENER = new ITaskActivityListener(){

            public void activityChanged(DateRangeContainer week) {
            }

            public void calendarChanged() {
            }

            public void taskActivated(ITask task) {
                boolean hasLocalContext = ContextCorePlugin.getContextManager().hasContext(task.getHandleIdentifier());
                if (!hasLocalContext && task instanceof AbstractRepositoryTask) {
                    boolean getRemote;
                    AbstractRepositoryTask repositoryTask = (AbstractRepositoryTask)task;
                    AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(repositoryTask);
                    TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository(repositoryTask.getRepositoryUrl());
                    if (connector != null && connector.hasRepositoryContext(repository, repositoryTask) && (getRemote = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Mylar Information", (String)"No local task context exists.  Retrieve from repository?"))) {
                        new ContextRetrieveAction().run(repositoryTask);
                    }
                }
            }

            public void taskDeactivated(ITask task) {
            }

            public void taskListRead() {
            }

            public void tasksActivated(List<ITask> tasks) {
            }
        };
    }

    public ContextUiPlugin() {
        INSTANCE = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.eclipse.mylar.MylarUiPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        catch (Throwable t) {
            MylarStatusHandler.log((Throwable)t, (String)"plug-in intialization failed");
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.initializeDefaultPreferences(this.getPreferenceStore());
        this.initializeHighlighters();
        this.initializeActions();
        this.viewerManager = new FocusedViewerManager();
        final IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    ContextCorePlugin.getContextManager().addListener((IMylarContextListener)ContextUiPlugin.this.viewerManager);
                    MylarMonitorUiPlugin.getDefault().addWindowPartListener((IPartListener)ContextUiPlugin.this.contentOutlineManager);
                    TasksUiPlugin.getDefault().setHighlighter(ContextUiPlugin.this.DEFAULT_HIGHLIGHTER);
                    TasksUiPlugin.getTaskListManager().addActivityListener((ITaskActivityListener)ContextUiPlugin.this.perspectiveManager);
                    TasksUiPlugin.getTaskListManager().addActivityListener(TASK_ACTIVATION_LISTENER);
                    workbench.addWindowListener((IWindowListener)ContextUiPlugin.this.activeSearchViewTracker);
                    IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
                    int i = 0;
                    while (i < windows.length) {
                        windows[i].addPageListener((IPageListener)ContextUiPlugin.this.activeSearchViewTracker);
                        IWorkbenchPage[] pages = windows[i].getPages();
                        int j = 0;
                        while (j < pages.length) {
                            pages[j].addPartListener((IPartListener2)ContextUiPlugin.this.activeSearchViewTracker);
                            ++j;
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    MylarStatusHandler.fail((Throwable)e, (String)"Context UI initialization failed", (boolean)true);
                }
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        try {
            super.stop(context);
            ContextCorePlugin.getContextManager().removeListener((IMylarContextListener)this.viewerManager);
            MylarMonitorUiPlugin.getDefault().removeWindowPartListener((IPartListener)this.contentOutlineManager);
            TasksUiPlugin.getTaskListManager().removeActivityListener((ITaskActivityListener)this.perspectiveManager);
            TasksUiPlugin.getTaskListManager().removeActivityListener(TASK_ACTIVATION_LISTENER);
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench != null) {
                workbench.removeWindowListener((IWindowListener)this.activeSearchViewTracker);
                IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
                int i = 0;
                while (i < windows.length) {
                    IWorkbenchPage[] pages = windows[i].getPages();
                    windows[i].removePageListener((IPageListener)this.activeSearchViewTracker);
                    int j = 0;
                    while (j < pages.length) {
                        pages[j].removePartListener((IPartListener2)this.activeSearchViewTracker);
                        ++j;
                    }
                    ++i;
                }
            }
            this.viewerManager.dispose();
            this.colorMap.dispose();
            this.highlighters.dispose();
        }
        catch (Exception e) {
            MylarStatusHandler.fail((Throwable)e, (String)"Mylar UI stop failed", (boolean)false);
        }
    }

    private void initializeActions() {
    }

    private void initializeHighlighters() {
        String hlist = this.getPreferenceStore().getString("org.eclipse.mylar.ui.interest.highlighters");
        if (hlist != null && hlist.length() != 0) {
            this.highlighters = new HighlighterList(hlist);
        } else {
            this.highlighters = new HighlighterList();
            this.highlighters.setToDefaultList();
            this.getPreferenceStore().setValue("org.eclipse.mylar.ui.interest.highlighters", this.highlighters.externalizeToString());
        }
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault("org.eclipse.mylar.context.ui.navigators.filter.auto.enable", true);
        store.setDefault("org.eclipse.mylar.ide.ui.perspectives.auto.manage", false);
        store.setDefault("org.eclipse.mylar.ide.ui.editors.auto.manage", true);
        store.setDefault("org.eclipse.mylar.ide.ui.editors.auto.open.num", 4);
        store.setDefault("org.eclipse.mylar.ide.ui.expansion.auto.manage", true);
        store.setDefault("org.eclipse.mylar.ui.gamma.lightened", false);
        store.setDefault("org.eclipse.mylar.ui.gamma.standard", true);
        store.setDefault("org.eclipse.mylar.ui.gamma.darkened", false);
    }

    public void setHighlighterMapping(String id, String name) {
        String prefId = "org.eclipse.mylar.ui.interest.highlighters.task." + id;
        this.getPreferenceStore().putValue(prefId, name);
    }

    public static ContextUiPlugin getDefault() {
        return INSTANCE;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = ContextUiPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static String getMessage(String key) {
        ResourceBundle bundle = ContextUiPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public boolean isDecorateInterestMode() {
        return this.decorateInterestMode;
    }

    public void setDecorateInterestMode(boolean decorateInterestLevel) {
        this.decorateInterestMode = decorateInterestLevel;
    }

    public List<AbstractContextUiBridge> getUiBridges() {
        UiExtensionPointReader.initExtensions();
        return new ArrayList<AbstractContextUiBridge>(this.bridges.values());
    }

    public AbstractContextUiBridge getUiBridge(String contentType) {
        UiExtensionPointReader.initExtensions();
        AbstractContextUiBridge bridge = this.bridges.get(contentType);
        if (bridge != null) {
            return bridge;
        }
        return DEFAULT_UI_BRIDGE;
    }

    public AbstractContextUiBridge getUiBridgeForEditor(IEditorPart editorPart) {
        UiExtensionPointReader.initExtensions();
        AbstractContextUiBridge foundBridge = null;
        for (AbstractContextUiBridge bridge : this.bridges.values()) {
            if (!bridge.acceptsEditor(editorPart)) continue;
            foundBridge = bridge;
            break;
        }
        if (foundBridge != null) {
            return foundBridge;
        }
        return DEFAULT_UI_BRIDGE;
    }

    private void internalAddBridge(String extension, AbstractContextUiBridge bridge) {
        this.bridges.put(extension, bridge);
    }

    public ILabelProvider getContextLabelProvider(String extension) {
        ILabelProvider provider = this.contextLabelProviders.get(extension);
        if (provider != null) {
            return provider;
        }
        return DEFAULT_LABEL_PROVIDER;
    }

    private void internalAddContextLabelProvider(String extension, ILabelProvider provider) {
        this.contextLabelProviders.put(extension, provider);
    }

    public void updateGammaSetting(ColorMap.GammaSetting setting) {
        if (this.colorMap.getGammaSetting() != setting) {
            this.highlighters.updateHighlighterWithGamma(this.colorMap.getGammaSetting(), setting);
            this.colorMap.setGammaSetting(setting);
        }
    }

    public ColorMap getColorMap() {
        return this.colorMap;
    }

    public Highlighter getDefaultHighlighter() {
        return HighlighterList.DEFAULT_HIGHLIGHTER;
    }

    public Highlighter getHighlighter(String name) {
        if (this.highlighters == null) {
            this.initializeHighlighters();
        }
        return this.highlighters.getHighlighter(name);
    }

    public Highlighter getHighlighterForContextId(String id) {
        String prefId = "org.eclipse.mylar.ui.interest.highlighters.task." + id;
        String highlighterName = this.getPreferenceStore().getString(prefId);
        return this.getHighlighter(highlighterName);
    }

    public HighlighterList getHighlighterList() {
        if (this.highlighters == null) {
            this.initializeHighlighters();
        }
        return this.highlighters;
    }

    public List<Highlighter> getHighlighters() {
        if (this.highlighters == null) {
            this.initializeHighlighters();
        }
        return this.highlighters.getHighlighters();
    }

    public Highlighter getIntersectionHighlighter() {
        return this.intersectionHighlighter;
    }

    public void setColorMap(ColorMap colorMap) {
        this.colorMap = colorMap;
    }

    public void setIntersectionHighlighter(Highlighter intersectionHighlighter) {
        this.intersectionHighlighter = intersectionHighlighter;
    }

    public boolean isIntersectionMode() {
        return this.getPreferenceStore().getBoolean("org.eclipse.mylar.ui.interest.intersection");
    }

    public void setIntersectionMode(boolean isIntersectionMode) {
        this.getPreferenceStore().setValue("org.eclipse.mylar.ui.interest.intersection", isIntersectionMode);
    }

    public FocusedViewerManager getViewerManager() {
        return this.viewerManager;
    }

    public String getPerspectiveIdFor(ITask task) {
        if (task != null) {
            return this.getPreferenceStore().getString("org.eclipse.mylar.ui.perspectives.task." + task.getHandleIdentifier());
        }
        return this.getPreferenceStore().getString("org.eclipse.mylar.ui.perspectives.task.none");
    }

    public void setPerspectiveIdFor(ITask task, String perspectiveId) {
        if (task != null) {
            this.getPreferenceStore().setValue("org.eclipse.mylar.ui.perspectives.task." + task.getHandleIdentifier(), perspectiveId);
        } else {
            this.getPreferenceStore().setValue("org.eclipse.mylar.ui.perspectives.task.none", perspectiveId);
        }
    }

    public void addWorkingSetManager(MylarWorkingSetManager updater) {
        if (this.workingSetUpdaters == null) {
            this.workingSetUpdaters = new ArrayList<MylarWorkingSetManager>();
        }
        this.workingSetUpdaters.add(updater);
        ContextCorePlugin.getContextManager().addListener((IMylarContextListener)updater);
    }

    public MylarWorkingSetManager getWorkingSetUpdater() {
        if (this.workingSetUpdaters == null) {
            return null;
        }
        return this.workingSetUpdaters.get(0);
    }

    private void setActiveSearchIcon(AbstractContextUiBridge bridge, ImageDescriptor descriptor) {
        this.activeSearchIcons.put(bridge, descriptor);
    }

    public ImageDescriptor getActiveSearchIcon(AbstractContextUiBridge bridge) {
        UiExtensionPointReader.initExtensions();
        return this.activeSearchIcons.get(bridge);
    }

    private void setActiveSearchLabel(AbstractContextUiBridge bridge, String label) {
        this.activeSearchLabels.put(bridge, label);
    }

    public String getActiveSearchLabel(AbstractContextUiBridge bridge) {
        UiExtensionPointReader.initExtensions();
        return this.activeSearchLabels.get(bridge);
    }

    public void updateDegreesOfSeparation(Collection<AbstractRelationProvider> providers, int degreeOfSeparation) {
        for (AbstractRelationProvider provider : providers) {
            this.updateDegreeOfSeparation(provider, degreeOfSeparation);
        }
    }

    public void updateDegreeOfSeparation(AbstractRelationProvider provider, int degreeOfSeparation) {
        ContextCorePlugin.getContextManager().resetLandmarkRelationshipsOfKind(provider.getId());
        ContextUiPlugin.getDefault().getPreferenceStore().setValue(provider.getGenericId(), degreeOfSeparation);
        provider.setDegreeOfSeparation(degreeOfSeparation);
        for (IMylarElement element : ContextCorePlugin.getContextManager().getActiveContext().getInteresting()) {
            if (!element.getInterest().isLandmark()) continue;
            provider.landmarkAdded(element);
        }
    }

    public void refreshRelatedElements() {
        try {
            for (AbstractRelationProvider provider : ContextCorePlugin.getDefault().getRelationProviders()) {
                ArrayList<AbstractRelationProvider> providerList = new ArrayList<AbstractRelationProvider>();
                providerList.add(provider);
                this.updateDegreesOfSeparation(providerList, provider.getCurrentDegreeOfSeparation());
            }
        }
        catch (Throwable t) {
            MylarStatusHandler.fail((Throwable)t, (String)"Could not refresn related elements", (boolean)false);
        }
    }

    public void addPreservedFilterClass(String viewId, ViewerFilter filter) {
        Set<Class<?>> preservedList = this.preservedFilterClasses.get(viewId);
        if (preservedList == null) {
            preservedList = new HashSet();
            this.preservedFilterClasses.put(viewId, preservedList);
        }
        preservedList.add(filter.getClass());
    }

    public Set<Class<?>> getPreservedFilterClasses(String viewId) {
        UiExtensionPointReader.initExtensions();
        if (this.preservedFilterClasses.containsKey(viewId)) {
            return this.preservedFilterClasses.get(viewId);
        }
        return Collections.emptySet();
    }

    public void addPreservedFilterId(String viewId, String filterId) {
        Set<String> preservedList = this.preservedFilterIds.get(viewId);
        if (preservedList == null) {
            preservedList = new HashSet<String>();
            this.preservedFilterIds.put(viewId, preservedList);
        }
        preservedList.add(filterId);
    }

    public Set<String> getPreservedFilterIds(String viewId) {
        UiExtensionPointReader.initExtensions();
        if (this.preservedFilterIds.containsKey(viewId)) {
            return this.preservedFilterIds.get(viewId);
        }
        return Collections.emptySet();
    }

    static class UiExtensionPointReader {
        private static boolean extensionsRead = false;
        private static UiExtensionPointReader thisReader = new UiExtensionPointReader();
        public static final String EXTENSION_ID_CONTEXT = "org.eclipse.mylar.context.ui.bridges";
        public static final String ELEMENT_UI_BRIDGE = "uiBridge";
        public static final String ELEMENT_PRESERVED_FILTERS = "preservedFilters";
        public static final String ELEMENT_VIEW_ID = "viewId";
        public static final String ELEMENT_ID = "id";
        public static final String ELEMENT_FILTER = "filter";
        public static final String ELEMENT_CLASS = "class";
        public static final String ELEMENT_UI_CONTEXT_LABEL_PROVIDER = "labelProvider";
        public static final String ELEMENT_UI_BRIDGE_CONTENT_TYPE = "contentType";
        public static final String ELEMENT_STRUCTURE_BRIDGE_SEARCH_ICON = "activeSearchIcon";
        public static final String ELEMENT_STRUCTURE_BRIDGE_SEARCH_LABEL = "activeSearchLabel";

        UiExtensionPointReader() {
        }

        public static void initExtensions() {
            if (!extensionsRead) {
                IExtensionRegistry registry = Platform.getExtensionRegistry();
                IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_ID_CONTEXT);
                IExtension[] extensions = extensionPoint.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                    int j = 0;
                    while (j < elements.length) {
                        if (elements[j].getName().equals(ELEMENT_UI_BRIDGE)) {
                            UiExtensionPointReader.readBridge(elements[j]);
                        } else if (elements[j].getName().equals(ELEMENT_UI_CONTEXT_LABEL_PROVIDER)) {
                            UiExtensionPointReader.readLabelProvider(elements[j]);
                        } else if (elements[j].getName().equals(ELEMENT_PRESERVED_FILTERS)) {
                            UiExtensionPointReader.readPreservedFilters(elements[j]);
                        }
                        ++j;
                    }
                    ++i;
                }
                extensionsRead = true;
            }
        }

        private static void readLabelProvider(IConfigurationElement element) {
            try {
                Object provider = element.createExecutableExtension(ELEMENT_CLASS);
                String contentType = element.getAttribute(ELEMENT_UI_BRIDGE_CONTENT_TYPE);
                if (provider instanceof ILabelProvider && contentType != null) {
                    ContextUiPlugin.getDefault().internalAddContextLabelProvider(contentType, (ILabelProvider)provider);
                } else {
                    MylarStatusHandler.log((String)("Could not load label provider: " + provider.getClass().getCanonicalName() + " must implement " + ILabelProvider.class.getCanonicalName()), (Object)thisReader);
                }
            }
            catch (CoreException e) {
                MylarStatusHandler.log((Throwable)e, (String)"Could not load label provider extension");
            }
        }

        private static void readPreservedFilters(IConfigurationElement element) {
            IConfigurationElement[] children;
            String viewId = element.getAttribute(ELEMENT_VIEW_ID);
            IConfigurationElement[] iConfigurationElementArray = children = element.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement child = iConfigurationElementArray[n2];
                if (child.getName().equals(ELEMENT_FILTER)) {
                    try {
                        Object filterClass = child.createExecutableExtension(ELEMENT_CLASS);
                        ContextUiPlugin.getDefault().addPreservedFilterClass(viewId, (ViewerFilter)filterClass);
                    }
                    catch (Exception exception) {
                        String filterId = child.getAttribute(ELEMENT_ID);
                        ContextUiPlugin.getDefault().addPreservedFilterId(viewId, filterId);
                    }
                }
                ++n2;
            }
        }

        private static void readBridge(IConfigurationElement element) {
            try {
                Object bridge = element.createExecutableExtension(ELEMENT_CLASS);
                String contentType = element.getAttribute(ELEMENT_UI_BRIDGE_CONTENT_TYPE);
                if (bridge instanceof AbstractContextUiBridge && contentType != null) {
                    String label;
                    ImageDescriptor descriptor;
                    ContextUiPlugin.getDefault().internalAddBridge(contentType, (AbstractContextUiBridge)bridge);
                    String iconPath = element.getAttribute(ELEMENT_STRUCTURE_BRIDGE_SEARCH_ICON);
                    if (iconPath != null && (descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)element.getDeclaringExtension().getNamespace(), (String)iconPath)) != null) {
                        ContextUiPlugin.getDefault().setActiveSearchIcon((AbstractContextUiBridge)bridge, descriptor);
                    }
                    if ((label = element.getAttribute(ELEMENT_STRUCTURE_BRIDGE_SEARCH_LABEL)) != null) {
                        ContextUiPlugin.getDefault().setActiveSearchLabel((AbstractContextUiBridge)bridge, label);
                    }
                } else {
                    MylarStatusHandler.log((String)("Could not load bridge: " + bridge.getClass().getCanonicalName() + " must implement " + AbstractContextUiBridge.class.getCanonicalName()), (Object)thisReader);
                }
            }
            catch (CoreException e) {
                MylarStatusHandler.log((Throwable)e, (String)"Could not load bridge extension");
            }
        }
    }
}

