/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.context.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mylar.context.core.AbstractContextStructureBridge;
import org.eclipse.mylar.context.core.ContextCorePlugin;
import org.eclipse.mylar.context.core.IAlwaysIntersting;
import org.eclipse.mylar.context.core.IMylarElement;
import org.eclipse.mylar.core.MylarStatusHandler;
import org.eclipse.mylar.internal.context.core.ContextManager;
import org.eclipse.swt.widgets.Tree;

public class InterestFilter
extends ViewerFilter {
    private Object temporarilyUnfiltered = null;

    public boolean select(Viewer viewer, Object parent, Object object) {
        IMylarElement element;
        block18: {
            AbstractContextStructureBridge bridge;
            block20: {
                block19: {
                    block17: {
                        block16: {
                            block15: {
                                block14: {
                                    if (viewer instanceof StructuredViewer && this.containsMylarInterestFilter((StructuredViewer)viewer)) break block14;
                                    return true;
                                }
                                if (!this.isTemporarilyUnfiltered(parent)) break block15;
                                return true;
                            }
                            if (!(this.temporarilyUnfiltered instanceof Tree) || !(object instanceof IProjectNature) && !(object instanceof IProject)) break block16;
                            return true;
                        }
                        element = null;
                        if (!(object instanceof IAlwaysIntersting)) break block17;
                        return true;
                    }
                    if (object instanceof IMylarElement) {
                        element = (IMylarElement)object;
                        break block18;
                    }
                    bridge = ContextCorePlugin.getDefault().getStructureBridge(object);
                    if (bridge.getContentType() != null) break block19;
                    if (object instanceof IAdaptable) {
                        Object adapted = ((IAdaptable)object).getAdapter(IResource.class);
                        if (adapted instanceof IResource) {
                            object = adapted;
                        }
                        bridge = ContextCorePlugin.getDefault().getStructureBridge(object);
                        break block19;
                    }
                    return false;
                }
                if (bridge.canFilter(object)) break block20;
                return true;
            }
            if (!object.getClass().getName().equals(Object.class.getCanonicalName())) {
                String handle = bridge.getHandleIdentifier(object);
                element = ContextCorePlugin.getContextManager().getElement(handle);
                break block18;
            }
            return true;
        }
        try {
            if (element != null) {
                return this.isInteresting(element);
            }
        }
        catch (Throwable t) {
            MylarStatusHandler.fail((Throwable)t, (String)("interest filter failed on viewer: " + viewer.getClass()), (boolean)false);
        }
        return false;
    }

    protected boolean isInteresting(IMylarElement element) {
        if (element.getInterest().isPredicted()) {
            return false;
        }
        return element.getInterest().getValue() > ContextManager.getScalingFactors().getInteresting();
    }

    private boolean isTemporarilyUnfiltered(Object parent) {
        if (parent instanceof TreePath) {
            TreePath treePath = (TreePath)parent;
            parent = treePath.getLastSegment();
        }
        return this.temporarilyUnfiltered != null && this.temporarilyUnfiltered.equals(parent);
    }

    protected boolean containsMylarInterestFilter(StructuredViewer viewer) {
        ViewerFilter[] viewerFilterArray = viewer.getFilters();
        int n = viewerFilterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter filter = viewerFilterArray[n2];
            if (filter instanceof InterestFilter) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setTemporarilyUnfiltered(Object temprarilyUnfiltered) {
        this.temporarilyUnfiltered = temprarilyUnfiltered;
    }

    public boolean resetTemporarilyUnfiltered() {
        if (this.temporarilyUnfiltered != null) {
            this.temporarilyUnfiltered = null;
            return true;
        }
        return false;
    }

    public Object getTemporarilyUnfiltered() {
        return this.temporarilyUnfiltered;
    }
}

