/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.context.ui;

public class ColorCoordinatesChange {
    public static double[] RGBToHSV(double R, double G, double B) {
        double minVal = Math.min(Math.min(R, G), B);
        double V = Math.max(Math.max(R, G), B);
        double Delta = V - minVal;
        double S = 0.0;
        double H = 0.0;
        S = V == 0.0 ? 0.0 : Delta / V;
        H = S == 0.0 ? 0.0 : (R == V ? 60.0 * (G - B) / Delta : (G == V ? 120.0 + 60.0 * (B - R) / Delta : 240.0 + 60.0 * (R - G) / Delta));
        if (H < 0.0) {
            H += 360.0;
        }
        return new double[]{H, S, V / 255.0};
    }

    public static int[] HSVtoRGB(double H, double S, double V) {
        double R = 0.0;
        double G = 0.0;
        double B = 0.0;
        if (S == 0.0) {
            R = V;
            G = V;
            B = V;
        } else {
            double hTemp = H == 360.0 ? 0.0 : H;
            int i = new Double(hTemp /= 60.0).intValue();
            double f = hTemp - (double)i;
            double p = V * (1.0 - S);
            double q = V * (1.0 - S * f);
            double t = V * (1.0 - S * (1.0 - f));
            switch (i) {
                case 0: {
                    R = V;
                    G = t;
                    B = p;
                    break;
                }
                case 1: {
                    R = q;
                    G = V;
                    B = p;
                    break;
                }
                case 2: {
                    R = p;
                    G = V;
                    B = t;
                    break;
                }
                case 3: {
                    R = p;
                    G = q;
                    B = V;
                    break;
                }
                case 4: {
                    R = t;
                    G = p;
                    B = V;
                    break;
                }
                case 5: {
                    R = V;
                    G = p;
                    B = q;
                }
            }
        }
        return new int[]{new Double(R * 255.0).intValue(), new Double(G * 255.0).intValue(), new Double(B * 255.0).intValue()};
    }
}

