/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.context.ui;

import java.util.List;
import org.eclipse.mylar.context.ui.ContextUiPlugin;
import org.eclipse.mylar.tasks.core.DateRangeContainer;
import org.eclipse.mylar.tasks.core.ITask;
import org.eclipse.mylar.tasks.core.ITaskActivityListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextPerspectiveManager
implements ITaskActivityListener {
    public void taskActivated(ITask task) {
        try {
            IPerspectiveDescriptor descriptor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective();
            ContextUiPlugin.getDefault().setPerspectiveIdFor(null, descriptor.getId());
            String perspectiveId = ContextUiPlugin.getDefault().getPerspectiveIdFor(task);
            this.showPerspective(perspectiveId);
        }
        catch (Exception exception) {}
    }

    public void taskDeactivated(ITask task) {
        try {
            if (PlatformUI.isWorkbenchRunning() && ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylar.ide.ui.perspectives.auto.manage")) {
                IPerspectiveDescriptor descriptor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective();
                ContextUiPlugin.getDefault().setPerspectiveIdFor(task, descriptor.getId());
                String previousPerspectiveId = ContextUiPlugin.getDefault().getPerspectiveIdFor(null);
                this.showPerspective(previousPerspectiveId);
            }
        }
        catch (Exception exception) {}
    }

    private void showPerspective(String perspectiveId) {
        if (perspectiveId != null && !"".equals(perspectiveId) && ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylar.ide.ui.perspectives.auto.manage")) {
            try {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().setRedraw(false);
                    PlatformUI.getWorkbench().showPerspective(perspectiveId, PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                }
                catch (Exception exception) {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().setRedraw(true);
                }
            }
            finally {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().setRedraw(true);
            }
        }
    }

    public void activityChanged(DateRangeContainer week) {
    }

    public void taskListRead() {
    }

    public void tasksActivated(List<ITask> tasks) {
    }

    public void calendarChanged() {
    }
}

