/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.context.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mylar.context.ui.ContextUiPlugin;
import org.eclipse.mylar.internal.context.ui.ColorCoordinatesChange;
import org.eclipse.mylar.internal.context.ui.ColorMap;
import org.eclipse.mylar.internal.context.ui.Highlighter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HighlighterList {
    public static final Highlighter DEFAULT_HIGHLIGHTER = new Highlighter("<none>", ColorMap.DEFAULT, false);
    private List<Highlighter> highlighters = new ArrayList<Highlighter>();

    public HighlighterList() {
    }

    public HighlighterList(List<Highlighter> hlist) {
        for (Highlighter highlighter : hlist) {
            this.highlighters.add(highlighter);
        }
    }

    public HighlighterList(String attributes) {
        this.internalizeFromString(attributes);
    }

    public void dispose() {
        for (Highlighter highlighter : this.highlighters) {
            highlighter.dispose();
        }
    }

    public void setToDefaultList() {
        this.highlighters.clear();
        this.highlighters.add(DEFAULT_HIGHLIGHTER);
        this.highlighters.add(new Highlighter("yellow", ColorMap.HIGHLIGHTER_YELLOW, false));
        this.highlighters.add(new Highlighter("rose", ColorMap.PANTONE_PASTEL_ROSE, false));
        this.highlighters.add(new Highlighter("purple", ColorMap.PANTONE_PASTEL_PURPLE, false));
        this.highlighters.add(new Highlighter("blue", ColorMap.PANTONE_PASTEL_BLUE, false));
        this.highlighters.add(new Highlighter("green", ColorMap.PANTONE_PASTERL_GREEN, false));
        this.highlighters.add(new Highlighter("blue gradient", ColorMap.HIGLIGHTER_BLUE_GRADIENT, true));
        this.highlighters.add(new Highlighter("orange gradient", ColorMap.HIGHLIGHTER_ORANGE_GRADIENT, true));
        Highlighter intersectionHighlighter = new Highlighter("intersection", ColorMap.HIGLIGHTER_RED_INTERSECTION, false);
        intersectionHighlighter.setIntersection(true);
        ContextUiPlugin.getDefault().setIntersectionHighlighter(intersectionHighlighter);
    }

    public void add(Highlighter hl) {
        this.highlighters.add(hl);
    }

    public List<Highlighter> getHighlighters() {
        return this.highlighters;
    }

    public Highlighter addHighlighter() {
        Highlighter hl = new Highlighter("new", ColorMap.GRAY_DARK, false);
        this.highlighters.add(hl);
        return hl;
    }

    public Highlighter getHighlighter(String name) {
        for (Highlighter highlighter : this.highlighters) {
            if (!highlighter.getName().equals(name)) continue;
            return highlighter;
        }
        return null;
    }

    public void removeHighlighter(Highlighter hl) {
        this.highlighters.remove(hl);
    }

    public String externalizeToString() {
        String result = "flag:";
        for (Highlighter highlighter : this.highlighters) {
            result = String.valueOf(result) + highlighter.externalizeToString() + ":";
        }
        return result;
    }

    public void internalizeFromString(String attributes) {
        if (attributes != null) {
            this.highlighters.clear();
            String[] data = attributes.split(":");
            int i = 1;
            while (i < data.length) {
                Highlighter hl = new Highlighter(data[i]);
                this.highlighters.add(hl);
                ++i;
            }
        }
    }

    public void updateHighlighterWithGamma(ColorMap.GammaSetting prev, ColorMap.GammaSetting curr) {
        int res = ColorMap.GammaSetting.compare(prev, curr);
        if (res < 0) {
            this.lightenAllColors(Math.abs(res));
        } else if (res > 0) {
            this.darkenAllColors(Math.abs(res));
        }
    }

    private void darkenAllColors(int degree) {
        for (Highlighter hl : this.highlighters) {
            Color c = hl.getCore();
            double[] HSV = ColorCoordinatesChange.RGBToHSV(c.getRed(), c.getGreen(), c.getBlue());
            HSV[1] = degree != 2 ? HSV[1] * 2.0 : HSV[1] * 3.0;
            if (HSV[1] > 1.0) {
                HSV[1] = 1.0;
            }
            int[] newRGB = ColorCoordinatesChange.HSVtoRGB(HSV[0], HSV[1], HSV[2]);
            Color rgb = new Color((Device)Display.getDefault(), newRGB[0], newRGB[1], newRGB[2]);
            hl.setCore(rgb);
        }
    }

    private void lightenAllColors(int degree) {
        for (Highlighter hl : this.highlighters) {
            Color c = hl.getCore();
            double[] HSV = ColorCoordinatesChange.RGBToHSV(c.getRed(), c.getGreen(), c.getBlue());
            HSV[1] = degree != 2 ? HSV[1] * 0.5 : HSV[1] * 0.333;
            int[] newRGB = ColorCoordinatesChange.HSVtoRGB(HSV[0], HSV[1], HSV[2]);
            Color rgb = new Color((Device)Display.getDefault(), newRGB[0], newRGB[1], newRGB[2]);
            hl.setCore(rgb);
        }
    }
}

