/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.context.ui;

import java.util.ConcurrentModificationException;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.mylar.context.core.AbstractContextStructureBridge;
import org.eclipse.mylar.context.core.ContextCorePlugin;
import org.eclipse.mylar.context.core.IMylarElement;
import org.eclipse.mylar.core.MylarStatusHandler;
import org.eclipse.mylar.internal.context.core.MylarContextRelation;
import org.eclipse.mylar.internal.context.ui.ColorMap;
import org.eclipse.mylar.internal.context.ui.ContextUiPrefContstants;
import org.eclipse.mylar.internal.context.ui.UiUtil;

public class InterestDecoratorLightweight
implements ILightweightLabelDecorator {
    public void decorate(Object element, IDecoration decoration) {
        AbstractContextStructureBridge bridge = null;
        try {
            if (ContextCorePlugin.getDefault() == null) {
                return;
            }
            bridge = ContextCorePlugin.getDefault().getStructureBridge(element);
        }
        catch (ConcurrentModificationException concurrentModificationException) {}
        try {
            IMylarElement node = null;
            if (element instanceof MylarContextRelation) {
                decoration.setForegroundColor(ColorMap.RELATIONSHIP);
            } else if (element instanceof IMylarElement) {
                node = (IMylarElement)element;
            } else if (bridge != null && bridge.getContentType() != null) {
                node = ContextCorePlugin.getContextManager().getElement(bridge.getHandleIdentifier(element));
            }
            if (node != null) {
                decoration.setBackgroundColor(UiUtil.getBackgroundForElement(node));
                decoration.setForegroundColor(UiUtil.getForegroundForElement(node));
                if (bridge != null && bridge.canBeLandmark(node.getHandleIdentifier()) && node.getInterest().isLandmark() && !node.getInterest().isPropagated() && !node.getInterest().isPredicted()) {
                    decoration.setFont(ContextUiPrefContstants.BOLD);
                }
            }
        }
        catch (Exception e) {
            MylarStatusHandler.log((Throwable)e, (String)"decoration failed");
        }
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

