/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.context.ui;

import java.util.Calendar;
import org.eclipse.mylar.core.MylarStatusHandler;
import org.eclipse.mylar.internal.tasks.ui.AbstractTaskListFilter;
import org.eclipse.mylar.tasks.core.AbstractQueryHit;
import org.eclipse.mylar.tasks.core.AbstractRepositoryTask;
import org.eclipse.mylar.tasks.core.DateRangeContainer;
import org.eclipse.mylar.tasks.core.ITask;
import org.eclipse.mylar.tasks.ui.TasksUiPlugin;

public class TaskListInterestFilter
extends AbstractTaskListFilter {
    public boolean select(Object parent, Object object) {
        block10: {
            block11: {
                ITask task;
                block12: {
                    if (object instanceof DateRangeContainer) {
                        DateRangeContainer dateRangeTaskContainer = (DateRangeContainer)object;
                        return this.isDateRangeInteresting(dateRangeTaskContainer);
                    }
                    if (!(object instanceof ITask) && !(object instanceof AbstractQueryHit)) break block10;
                    task = null;
                    if (object instanceof ITask) {
                        task = (ITask)object;
                    } else if (object instanceof AbstractQueryHit) {
                        task = ((AbstractQueryHit)object).getCorrespondingTask();
                    }
                    if (task == null) break block11;
                    if (!this.isUninteresting(parent, task)) break block12;
                    return false;
                }
                if (this.isInteresting(parent, task)) {
                    return true;
                }
            }
            try {
                if (object instanceof AbstractQueryHit) {
                    return true;
                }
            }
            catch (Throwable t) {
                MylarStatusHandler.fail((Throwable)t, (String)"interest filter failed", (boolean)false);
            }
        }
        return false;
    }

    private boolean isDateRangeInteresting(DateRangeContainer container) {
        return TasksUiPlugin.getTaskListManager().isWeekDay(container);
    }

    protected boolean isUninteresting(Object parent, ITask task) {
        return !task.isActive() && !this.hasInterestingSubTasks(parent, task, true) && (task.isCompleted() && !TasksUiPlugin.getTaskListManager().isCompletedToday(task) && !TaskListInterestFilter.hasChanges(parent, task) || TasksUiPlugin.getTaskListManager().isScheduledAfterThisWeek(task) && !TaskListInterestFilter.hasChanges(parent, task));
    }

    protected boolean isInteresting(Object parent, ITask task) {
        return this.shouldAlwaysShow(parent, task, !TasksUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylar.tasklist.filter.subtasks"));
    }

    public boolean shouldAlwaysShow(Object parent, ITask task, boolean checkSubTasks) {
        return super.shouldAlwaysShow(parent, task, checkSubTasks) || TaskListInterestFilter.hasChanges(parent, task) || TasksUiPlugin.getTaskListManager().isCompletedToday(task) || TaskListInterestFilter.shouldShowInFocusedWorkweekDateContainer(parent, task) || TaskListInterestFilter.isInterestingForThisWeek(parent, task) && !task.isCompleted() || TasksUiPlugin.getTaskListManager().isOverdue(task) || this.hasInterestingSubTasks(parent, task, checkSubTasks) || "New Task".equals(task.getSummary());
    }

    private boolean hasInterestingSubTasks(Object parent, ITask task, boolean checkSubTasks) {
        if (!checkSubTasks) {
            return false;
        }
        if (TasksUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylar.tasklist.filter.subtasks")) {
            return false;
        }
        if (task.getChildren() != null && task.getChildren().size() > 0) {
            for (ITask subTask : task.getChildren()) {
                if (!this.shouldAlwaysShow(parent, subTask, false)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean shouldShowInFocusedWorkweekDateContainer(Object parent, ITask task) {
        if (parent instanceof DateRangeContainer) {
            if (TasksUiPlugin.getTaskListManager().isOverdue(task) || task.isPastReminder()) {
                return true;
            }
            DateRangeContainer container = (DateRangeContainer)parent;
            Calendar previousCal = TasksUiPlugin.getTaskListManager().getActivityPrevious().getEnd();
            Calendar nextCal = TasksUiPlugin.getTaskListManager().getActivityNextWeek().getStart();
            if (container.getEnd().compareTo(previousCal) > 0 && container.getStart().compareTo(nextCal) < 0) {
                return true;
            }
        }
        return false;
    }

    public static boolean isInterestingForThisWeek(Object parent, ITask task) {
        if (parent instanceof DateRangeContainer) {
            return TaskListInterestFilter.shouldShowInFocusedWorkweekDateContainer(parent, task);
        }
        return TasksUiPlugin.getTaskListManager().isScheduledForThisWeek(task) || TasksUiPlugin.getTaskListManager().isScheduledForToday(task) || task.isPastReminder();
    }

    public static boolean hasChanges(Object parent, ITask task) {
        if (parent instanceof DateRangeContainer && !TaskListInterestFilter.shouldShowInFocusedWorkweekDateContainer(parent, task)) {
            return false;
        }
        if (task instanceof AbstractRepositoryTask) {
            AbstractRepositoryTask repositoryTask = (AbstractRepositoryTask)task;
            if (repositoryTask.getSyncState() == AbstractRepositoryTask.RepositoryTaskSyncState.OUTGOING) {
                return true;
            }
            if (repositoryTask.getSyncState() == AbstractRepositoryTask.RepositoryTaskSyncState.INCOMING && !(parent instanceof DateRangeContainer)) {
                return true;
            }
            if (repositoryTask.getSyncState() == AbstractRepositoryTask.RepositoryTaskSyncState.CONFLICT) {
                return true;
            }
        }
        return false;
    }
}

