/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.context.ui;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylar.context.core.ContextCorePlugin;
import org.eclipse.mylar.context.core.IMylarElement;
import org.eclipse.mylar.context.ui.ContextUiPlugin;
import org.eclipse.mylar.internal.context.core.ContextManager;
import org.eclipse.mylar.internal.context.ui.ColorMap;
import org.eclipse.mylar.internal.context.ui.Highlighter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class UiUtil {
    public static void displayInterestManipulationFailure() {
        MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Mylar Interest Manipulation", (String)"Not a valid landmark, select an element within this resource instead.");
    }

    public static Color getBackgroundForElement(IMylarElement node) {
        return UiUtil.getBackgroundForElement(node, false);
    }

    public static Color getBackgroundForElement(IMylarElement node, boolean resolveContextColor) {
        if (node == null) {
            return null;
        }
        if (!resolveContextColor && (node.getInterest().isPropagated() || node.getInterest().isPredicted())) {
            return null;
        }
        if (node.getInterest().getEncodedValue() <= ContextManager.getScalingFactors().getInteresting()) {
            return null;
        }
        boolean isMultiple = false;
        String contextId = ContextCorePlugin.getContextManager().getDominantContextHandleForElement(node);
        if (contextId != null) {
            Highlighter highlighter = ContextUiPlugin.getDefault().getHighlighterForContextId(contextId);
            if (highlighter == null) {
                return null;
            }
            if (ContextUiPlugin.getDefault().isIntersectionMode()) {
                if (isMultiple) {
                    return ContextUiPlugin.getDefault().getIntersectionHighlighter().getHighlightColor();
                }
                return null;
            }
            return highlighter.getHighlight(node, false);
        }
        return ColorMap.BACKGROUND_COLOR;
    }

    public static Color getForegroundForElement(IMylarElement node) {
        if (node == null) {
            return null;
        }
        if (node.getInterest().isPredicted() || node.getInterest().isPropagated()) {
            if (node.getInterest().getValue() >= ContextManager.getScalingFactors().getLandmark() / 3.0f) {
                return ColorMap.GRAY_DARK;
            }
            if (node.getInterest().getValue() >= 10.0f) {
                return ColorMap.GRAY_MEDIUM;
            }
            return ColorMap.GRAY_LIGHT;
        }
        if (node.getInterest().isLandmark()) {
            return ColorMap.LANDMARK;
        }
        if (node.getInterest().isInteresting()) {
            return null;
        }
        return ColorMap.GRAY_MEDIUM;
    }
}

