/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.context.ui.actions;

import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.mylar.context.core.ContextCorePlugin;
import org.eclipse.mylar.context.core.IMylarContext;
import org.eclipse.mylar.context.core.IMylarContextListener;
import org.eclipse.mylar.context.core.IMylarElement;
import org.eclipse.mylar.context.ui.ContextUiPlugin;
import org.eclipse.mylar.context.ui.InterestFilter;
import org.eclipse.mylar.core.MylarStatusHandler;
import org.eclipse.mylar.internal.context.ui.actions.AbstractFocusViewAction;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAutoFocusViewAction
extends AbstractFocusViewAction
implements IMylarContextListener {
    public AbstractAutoFocusViewAction(InterestFilter interestFilter, boolean manageViewer, boolean manageFilters, boolean manageLinking) {
        super(interestFilter, manageViewer, manageFilters, manageLinking);
        ContextCorePlugin.getContextManager().addListener((IMylarContextListener)this);
    }

    @Override
    public void dispose() {
        ContextCorePlugin.getContextManager().removeListener((IMylarContextListener)this);
    }

    @Override
    public void init(IAction action) {
        super.init(action);
        this.configureAction();
    }

    private void configureAction() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    if (ContextCorePlugin.getContextManager().isContextActive() && ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylar.context.ui.navigators.filter.auto.enable")) {
                        AbstractAutoFocusViewAction.this.update(true);
                    }
                }
                catch (Exception e) {
                    MylarStatusHandler.fail((Throwable)e, (String)("could not toggle Mylar on view: " + AbstractAutoFocusViewAction.this.getPartForAction()), (boolean)true);
                }
            }
        });
    }

    public void contextActivated(IMylarContext context) {
        if (ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylar.context.ui.navigators.filter.auto.enable")) {
            this.update(true);
        }
    }

    public void contextDeactivated(IMylarContext context) {
        if (ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylar.context.ui.navigators.filter.auto.enable")) {
            this.update(false);
        }
    }

    public void contextCleared(IMylarContext context) {
    }

    public void relationsChanged(IMylarElement element) {
    }

    public void interestChanged(List<IMylarElement> elements) {
    }

    public void landmarkAdded(IMylarElement element) {
    }

    public void landmarkRemoved(IMylarElement element) {
    }

    public void elementDeleted(IMylarElement element) {
    }
}

