/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.context.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylar.context.core.ContextCorePlugin;
import org.eclipse.mylar.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylar.internal.tasks.ui.wizards.ContextAttachWizard;
import org.eclipse.mylar.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylar.tasks.core.AbstractRepositoryTask;
import org.eclipse.mylar.tasks.core.IAttachmentHandler;
import org.eclipse.mylar.tasks.core.ITask;
import org.eclipse.mylar.tasks.core.TaskRepository;
import org.eclipse.mylar.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

public class ContextAttachAction
implements IViewActionDelegate {
    private AbstractRepositoryTask task;
    private TaskRepository repository;
    private AbstractRepositoryConnector connector;

    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        if (this.task == null) {
            return;
        }
        this.run(this.task);
    }

    public void run(AbstractRepositoryTask task) {
        if (task.getSyncState() != AbstractRepositoryTask.RepositoryTaskSyncState.SYNCHRONIZED) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Mylar Information", (String)"Task must be synchronized before attaching context");
            return;
        }
        ContextAttachWizard wizard = new ContextAttachWizard(task);
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (wizard != null && shell != null && !shell.isDisposed()) {
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            dialog.create();
            dialog.setTitle("Attach context");
            dialog.setBlockOnOpen(true);
            if (dialog.open() == 1) {
                dialog.close();
                return;
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        ITask selectedTask = TaskListView.getSelectedTask((ISelection)selection);
        if (selectedTask instanceof AbstractRepositoryTask) {
            this.task = (AbstractRepositoryTask)selectedTask;
            this.repository = TasksUiPlugin.getRepositoryManager().getRepository(this.task.getRepositoryKind(), this.task.getRepositoryUrl());
            this.connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(this.task.getRepositoryKind());
            IAttachmentHandler handler = this.connector.getAttachmentHandler();
            action.setEnabled(handler != null && handler.canUploadAttachment(this.repository, this.task) && (this.task.isActive() || ContextCorePlugin.getContextManager().hasContext(this.task.getHandleIdentifier())));
        } else {
            this.task = null;
            action.setEnabled(false);
        }
    }
}

