/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.context.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylar.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylar.internal.tasks.ui.wizards.ContextRetrieveWizard;
import org.eclipse.mylar.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylar.tasks.core.AbstractRepositoryTask;
import org.eclipse.mylar.tasks.core.IAttachmentHandler;
import org.eclipse.mylar.tasks.core.ITask;
import org.eclipse.mylar.tasks.core.RepositoryAttachment;
import org.eclipse.mylar.tasks.core.TaskRepository;
import org.eclipse.mylar.tasks.ui.TasksUiPlugin;
import org.eclipse.mylar.tasks.ui.editors.TaskEditor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

public class ContextRetrieveAction
implements IViewActionDelegate {
    private AbstractRepositoryTask task;
    private TaskRepository repository;
    private AbstractRepositoryConnector connector;
    private StructuredSelection selection;

    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        if (this.task != null) {
            this.run(this.task);
        } else if (this.selection.getFirstElement() instanceof RepositoryAttachment) {
            RepositoryAttachment attachment = (RepositoryAttachment)this.selection.getFirstElement();
            IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            ITask currentTask = null;
            if (activeEditor instanceof TaskEditor) {
                currentTask = ((TaskEditor)activeEditor).getTaskEditorInput().getTask();
            }
            if (currentTask instanceof AbstractRepositoryTask) {
                ContextRetrieveWizard.retrieveContext((AbstractRepositoryTask)((AbstractRepositoryTask)currentTask), (RepositoryAttachment)attachment);
            } else {
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Retrieve Context", (String)"Can not retrieve contenxt for local tasks.");
            }
        }
    }

    public void run(AbstractRepositoryTask task) {
        ContextRetrieveWizard wizard = new ContextRetrieveWizard(task);
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (wizard != null && shell != null && !shell.isDisposed()) {
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            dialog.create();
            dialog.setTitle("Retrieve context");
            dialog.setBlockOnOpen(true);
            if (dialog.open() == 1) {
                dialog.close();
                return;
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        ITask selectedTask = TaskListView.getSelectedTask((ISelection)selection);
        if (selectedTask == null) {
            StructuredSelection structuredSelection;
            this.selection = structuredSelection = (StructuredSelection)selection;
            if (structuredSelection.getFirstElement() instanceof RepositoryAttachment) {
                RepositoryAttachment attachment = (RepositoryAttachment)structuredSelection.getFirstElement();
                if ("mylar/context/zip".equals(attachment.getDescription())) {
                    action.setEnabled(true);
                } else {
                    action.setEnabled(false);
                }
            }
        } else if (selectedTask instanceof AbstractRepositoryTask) {
            this.task = (AbstractRepositoryTask)selectedTask;
            this.repository = TasksUiPlugin.getRepositoryManager().getRepository(this.task.getRepositoryKind(), this.task.getRepositoryUrl());
            this.connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(this.task.getRepositoryKind());
            IAttachmentHandler handler = this.connector.getAttachmentHandler();
            action.setEnabled(handler != null && handler.canDownloadAttachment(this.repository, this.task) && this.connector.hasRepositoryContext(this.repository, this.task));
        } else {
            this.task = null;
            action.setEnabled(false);
        }
    }
}

