/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.context.ui.actions;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylar.context.core.AbstractContextStructureBridge;
import org.eclipse.mylar.context.core.ContextCorePlugin;
import org.eclipse.mylar.context.core.IMylarElement;
import org.eclipse.mylar.context.ui.InterestFilter;
import org.eclipse.mylar.internal.tasks.ui.TasksUiImages;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.internal.navigator.NavigatorContentServiceContentProvider;
import org.eclipse.ui.navigator.CommonViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveFromContextAction
extends BaseSelectionListenerAction {
    public static final String ID = "org.eclipse.mylar.context.ui.actions.delete";
    private CommonViewer commonViewer;
    private InterestFilter interestFilter;

    public RemoveFromContextAction(CommonViewer commonViewer, InterestFilter interestFilter) {
        super("Remove from Context");
        this.setId(ID);
        this.setImageDescriptor(TasksUiImages.REMOVE);
        this.commonViewer = commonViewer;
        this.interestFilter = interestFilter;
    }

    public void run() {
        HashSet<IMylarElement> toRemove = new HashSet<IMylarElement>();
        for (Object object : super.getStructuredSelection()) {
            this.collectChildren(toRemove, object);
        }
        for (IMylarElement element : toRemove) {
            ContextCorePlugin.getContextManager().delete(element);
        }
        this.commonViewer.refresh();
    }

    private void collectChildren(Set<IMylarElement> toRemove, Object object) {
        IMylarElement element = this.resolveElement(object);
        if (element != null) {
            toRemove.add(element);
        }
        Object[] children = ((NavigatorContentServiceContentProvider)this.commonViewer.getContentProvider()).getChildren(object);
        int i = 0;
        while (i < children.length) {
            Object child = children[i];
            if (this.interestFilter.select((Viewer)this.commonViewer, object, child)) {
                this.collectChildren(toRemove, child);
            }
            ++i;
        }
    }

    private IMylarElement resolveElement(Object object) {
        IMylarElement element = null;
        if (object instanceof IMylarElement) {
            element = (IMylarElement)object;
        } else {
            AbstractContextStructureBridge bridge = ContextCorePlugin.getDefault().getStructureBridge(object);
            if (bridge.getContentType() == null && object instanceof IAdaptable) {
                Object adapted = ((IAdaptable)object).getAdapter(IResource.class);
                if (adapted instanceof IResource) {
                    object = adapted;
                }
                bridge = ContextCorePlugin.getDefault().getStructureBridge(object);
            }
            if (!object.getClass().getName().equals(Object.class.getCanonicalName())) {
                String handle = bridge.getHandleIdentifier(object);
                element = ContextCorePlugin.getContextManager().getElement(handle);
            }
        }
        return element;
    }
}

