/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.context.ui.actions;

import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.mylar.context.core.AbstractRelationProvider;
import org.eclipse.mylar.context.core.IDegreeOfSeparation;
import org.eclipse.mylar.context.ui.AbstractContextUiBridge;
import org.eclipse.mylar.context.ui.ContextUiPlugin;
import org.eclipse.mylar.core.MylarStatusHandler;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToggleRelationshipProviderAction
extends Action
implements IMenuCreator {
    private static final String LABEL_DEGREE_OF_SEPARATION = "Degree of Separation:";
    public static final String ID = "org.eclipse.mylar.ui.actions.active.search.toggle";
    private Set<AbstractRelationProvider> providers;
    private Menu dropDownMenu = null;
    private int degreeOfSeparation = 0;

    public ToggleRelationshipProviderAction(Set<AbstractRelationProvider> providers, AbstractContextUiBridge uiBridge) {
        this.providers = providers;
        this.setImageDescriptor(ContextUiPlugin.getDefault().getActiveSearchIcon(uiBridge));
        this.setId(ID);
        this.setText(ContextUiPlugin.getDefault().getActiveSearchLabel(uiBridge));
        this.setToolTipText(ContextUiPlugin.getDefault().getActiveSearchLabel(uiBridge));
        this.setMenuCreator(this);
        this.degreeOfSeparation = this.getCurrentProvider().getCurrentDegreeOfSeparation();
        if (this.degreeOfSeparation > 0) {
            this.run();
        }
    }

    private AbstractRelationProvider getCurrentProvider() {
        return this.providers.iterator().next();
    }

    public void run() {
        ContextUiPlugin.getDefault().updateDegreesOfSeparation(this.providers, this.degreeOfSeparation);
    }

    public void dispose() {
        if (this.dropDownMenu != null) {
            this.dropDownMenu.dispose();
            this.dropDownMenu = null;
        }
    }

    public Menu getMenu(Control parent) {
        if (this.dropDownMenu != null) {
            this.dropDownMenu.dispose();
        }
        this.dropDownMenu = new Menu(parent);
        this.addActionsToMenu();
        return this.dropDownMenu;
    }

    public Menu getMenu(Menu parent) {
        if (this.dropDownMenu != null) {
            this.dropDownMenu.dispose();
        }
        this.dropDownMenu = new Menu(parent);
        this.addActionsToMenu();
        return this.dropDownMenu;
    }

    public void addActionsToMenu() {
        this.degreeOfSeparation = this.getCurrentProvider().getCurrentDegreeOfSeparation();
        MenuItem menuItem = new MenuItem(this.dropDownMenu, 0);
        menuItem.setText(LABEL_DEGREE_OF_SEPARATION);
        new MenuItem(this.dropDownMenu, 2);
        for (IDegreeOfSeparation separation : this.getCurrentProvider().getDegreesOfSeparation()) {
            Action degreeOfSeparationSelectionAction = new Action(String.valueOf(separation.getDegree()) + ": " + separation.getLabel(), 2){

                public void run() {
                    try {
                        ToggleRelationshipProviderAction.this.degreeOfSeparation = Integer.parseInt(this.getId());
                        ContextUiPlugin.getDefault().updateDegreesOfSeparation(ToggleRelationshipProviderAction.this.providers, ToggleRelationshipProviderAction.this.degreeOfSeparation);
                    }
                    catch (NumberFormatException e) {
                        MylarStatusHandler.fail((Throwable)e, (String)"invalid degree of separation", (boolean)false);
                    }
                }
            };
            degreeOfSeparationSelectionAction.setId("" + separation.getDegree());
            degreeOfSeparationSelectionAction.setEnabled(true);
            degreeOfSeparationSelectionAction.setToolTipText(separation.getLabel());
            ActionContributionItem item = new ActionContributionItem((IAction)degreeOfSeparationSelectionAction);
            item.fill(this.dropDownMenu, -1);
            degreeOfSeparationSelectionAction.setChecked(false);
            if (this.degreeOfSeparation == 0 && separation.getDegree() == 0) {
                degreeOfSeparationSelectionAction.setChecked(true);
                continue;
            }
            if (this.degreeOfSeparation == 0 || separation.getDegree() == 0 || this.degreeOfSeparation != separation.getDegree()) continue;
            degreeOfSeparationSelectionAction.setChecked(true);
        }
    }
}

