/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.context.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.mylar.context.ui.ContextUiPlugin;
import org.eclipse.swt.graphics.Image;

public class ContextUiImages {
    private static ImageRegistry imageRegistry;
    public static final String T_ELCL = "elcl16";
    public static final String T_TOOL = "etool16";
    public static final String T_VIEW = "eview16";
    private static final URL baseURL;
    public static final ImageDescriptor CONTEXT_ADD;
    public static final ImageDescriptor CONTEXT_ATTACH;
    public static final ImageDescriptor CONTEXT_RETRIEVE;
    public static final ImageDescriptor CONTEXT_COPY;
    public static final ImageDescriptor MYLAR;
    public static final ImageDescriptor MYLAR_OVERLAY;
    public static final ImageDescriptor DECORATE_INTEREST;
    public static final ImageDescriptor SYNCHED;
    public static final ImageDescriptor REMOVE;
    public static final ImageDescriptor ERASE_TASKSCAPE;
    public static final ImageDescriptor INTEREST_LANDMARK;
    public static final ImageDescriptor INTEREST_FILTERING;
    public static final ImageDescriptor INTEREST_FOLDING;
    public static final ImageDescriptor CAPTURE_PAUSE;
    public static final ImageDescriptor CAPTURE_RESUME;
    public static final ImageDescriptor FILTER_COMPLETE;
    public static final ImageDescriptor FILTER_PRIORITY;
    public static final ImageDescriptor COPY;
    public static final ImageDescriptor COLOR_PALETTE;
    public static final ImageDescriptor STOP_SEARCH;
    public static final ImageDescriptor CONTENT_ASSIST_SEPARATOR;
    public static final ImageDescriptor QUALIFY_NAMES;
    public static final ImageDescriptor EDGE_INHERITANCE;
    public static final ImageDescriptor EDGE_REFERENCE;
    public static final ImageDescriptor EDGE_ACCESS_READ;
    public static final ImageDescriptor EDGE_ACCESS_WRITE;
    public static final ImageDescriptor IMPORT_ZIP;
    public static final ImageDescriptor FILE_XML;
    public static final ImageDescriptor FILE_GENERIC;
    public static final ImageDescriptor FOLDER_GENERIC;
    public static final ImageDescriptor LINK_WITH_EDITOR;
    public static final ImageDescriptor BLANK;

    static {
        baseURL = ContextUiPlugin.getDefault().getBundle().getEntry("/icons/");
        CONTEXT_ADD = ContextUiImages.create(T_TOOL, "context-add.gif");
        CONTEXT_ATTACH = ContextUiImages.create(T_TOOL, "context-attach.gif");
        CONTEXT_RETRIEVE = ContextUiImages.create(T_TOOL, "context-retrieve.gif");
        CONTEXT_COPY = ContextUiImages.create(T_ELCL, "context-transfer.gif");
        MYLAR = ContextUiImages.create(T_ELCL, "mylar.gif");
        MYLAR_OVERLAY = ContextUiImages.create(T_ELCL, "mylar-overlay.gif");
        DECORATE_INTEREST = ContextUiImages.create(T_ELCL, "refresh.gif");
        SYNCHED = ContextUiImages.create(T_ELCL, "synched.gif");
        REMOVE = ContextUiImages.create(T_ELCL, "remove.gif");
        ERASE_TASKSCAPE = ContextUiImages.create(T_ELCL, "context-clear.gif");
        INTEREST_LANDMARK = ContextUiImages.create(T_ELCL, "interest-landmark.gif");
        INTEREST_FILTERING = ContextUiImages.create(T_ELCL, "interest-filtering.gif");
        INTEREST_FOLDING = ContextUiImages.create(T_ELCL, "interest-filtering.gif");
        CAPTURE_PAUSE = ContextUiImages.create(T_ELCL, "capture-pause.gif");
        CAPTURE_RESUME = ContextUiImages.create(T_ELCL, "capture-resume.gif");
        FILTER_COMPLETE = ContextUiImages.create(T_ELCL, "filter-complete.gif");
        FILTER_PRIORITY = ContextUiImages.create(T_ELCL, "filter-priority.gif");
        COPY = ContextUiImages.create(T_ELCL, "copy.png");
        COLOR_PALETTE = ContextUiImages.create(T_ELCL, "color-palette.gif");
        STOP_SEARCH = ContextUiImages.create(T_ELCL, "stop_all.gif");
        CONTENT_ASSIST_SEPARATOR = ContextUiImages.create(T_TOOL, "content-assist-separator.gif");
        QUALIFY_NAMES = ContextUiImages.create(T_TOOL, "qualify-names.gif");
        EDGE_INHERITANCE = ContextUiImages.create(T_ELCL, "edge-inheritance.gif");
        EDGE_REFERENCE = ContextUiImages.create(T_ELCL, "edge-reference.gif");
        EDGE_ACCESS_READ = ContextUiImages.create(T_ELCL, "edge-read.gif");
        EDGE_ACCESS_WRITE = ContextUiImages.create(T_ELCL, "edge-write.gif");
        IMPORT_ZIP = ContextUiImages.create(T_ELCL, "import-zip.gif");
        FILE_XML = ContextUiImages.create(T_ELCL, "file-xml.gif");
        FILE_GENERIC = ContextUiImages.create(T_ELCL, "file_obj.gif");
        FOLDER_GENERIC = ContextUiImages.create(T_ELCL, "fldr_obj.gif");
        LINK_WITH_EDITOR = ContextUiImages.create(T_ELCL, "link-with-editor.gif");
        BLANK = ContextUiImages.create(T_ELCL, "blank.gif");
    }

    public static ImageDescriptor create(String prefix, String name) {
        return ContextUiImages.create(prefix, name, baseURL);
    }

    public static ImageDescriptor create(String prefix, String name, URL baseURL) {
        try {
            return ImageDescriptor.createFromURL((URL)ContextUiImages.makeIconFileURL(prefix, name, baseURL));
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static URL makeIconFileURL(String prefix, String name, URL baseURL) throws MalformedURLException {
        if (baseURL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append('/');
        buffer.append(name);
        return new URL(baseURL, buffer.toString());
    }

    private static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
        }
        return imageRegistry;
    }

    public static Image getImage(ImageDescriptor imageDescriptor) {
        if (imageDescriptor == null) {
            return null;
        }
        ImageRegistry imageRegistry = ContextUiImages.getImageRegistry();
        Image image = imageRegistry.get("" + imageDescriptor.hashCode());
        if (image == null) {
            image = imageDescriptor.createImage();
            imageRegistry.put("" + imageDescriptor.hashCode(), image);
        }
        return image;
    }
}

