/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.context.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mylar.context.core.IInteractionElement;
import org.eclipse.mylar.core.MylarStatusHandler;
import org.eclipse.mylar.internal.context.ui.ColorMap;
import org.eclipse.mylar.internal.context.ui.HighlighterList;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Highlighter {
    private static final String LABEL_SOLID = "Solid";
    private static final String LABEL_INTERSECTION = "Intersection";
    private static final String LABEL_GRADIENT = "Gradient";
    private static final int NUM_LEVELS = 17;
    private static final String VAL_DEFAULT = "";
    private final List<Color> gradients = new ArrayList<Color>();
    private String name;
    private Color core;
    private Color highlightColor;
    private boolean isGradient;
    private boolean isIntersection;

    public boolean isIntersection() {
        return this.isIntersection;
    }

    public void setIntersection(boolean isIntersection) {
        this.isIntersection = isIntersection;
    }

    public Highlighter(String name, Color coreColor, boolean isGradient) {
        this.name = name;
        this.core = coreColor;
        this.isGradient = isGradient;
        if (coreColor != null) {
            this.initializeHighlight();
            this.initializeGradients();
        }
    }

    public Highlighter(String attributes) {
        if (this.initializeFromString(attributes)) {
            this.initializeHighlight();
            this.initializeGradients();
        }
    }

    public void dispose() {
        for (Color color : this.gradients) {
            color.dispose();
        }
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public Color getHighlight(IInteractionElement info, boolean isLandmark) {
        if (info.getInterest().getValue() > 0.0f) {
            if (this.isGradient) {
                return this.mapDoiToElevation(info);
            }
            return this.highlightColor;
        }
        return ColorMap.COLOR_WHITE;
    }

    public Color mapDoiToElevation(IInteractionElement element) {
        if (element == null) {
            return ColorMap.COLOR_WHITE;
        }
        if (element.getInterest().getValue() < 0.0f) {
            return this.highlightColor;
        }
        int step = 2;
        Color color2 = ColorMap.COLOR_WHITE;
        for (Color color2 : this.gradients) {
            if (element.getInterest().getValue() < (float)step) {
                return color2;
            }
            step += 2;
        }
        return color2;
    }

    private void initializeHighlight() {
        try {
            int redStep = (int)Math.ceil((this.core.getRed() + 2 * ColorMap.COLOR_WHITE.getRed()) / 3);
            int greenStep = (int)Math.ceil((this.core.getGreen() + 2 * ColorMap.COLOR_WHITE.getGreen()) / 3);
            int blueStep = (int)Math.ceil((this.core.getBlue() + 2 * ColorMap.COLOR_WHITE.getBlue()) / 3);
            this.highlightColor = new Color((Device)Display.getDefault(), redStep, greenStep, blueStep);
        }
        catch (Throwable t) {
            MylarStatusHandler.log((Throwable)t, (String)"highlighter init failed");
        }
    }

    private void initializeGradients() {
        try {
            int redStep = (int)Math.ceil((this.highlightColor.getRed() - ColorMap.COLOR_WHITE.getRed()) / 17);
            int greenStep = (int)Math.ceil((this.highlightColor.getGreen() - ColorMap.COLOR_WHITE.getGreen()) / 17);
            int blueStep = (int)Math.ceil((this.highlightColor.getBlue() - ColorMap.COLOR_WHITE.getBlue()) / 17);
            int OFFSET = 1;
            int red = ColorMap.COLOR_WHITE.getRed() + redStep * OFFSET;
            int green = ColorMap.COLOR_WHITE.getGreen() + greenStep * OFFSET;
            int blue = ColorMap.COLOR_WHITE.getBlue() + blueStep * OFFSET;
            int i = 0;
            while (i < 17 - OFFSET) {
                if (red > 255) {
                    red = 255;
                }
                if (green > 255) {
                    green = 255;
                }
                if (blue > 255) {
                    blue = 255;
                }
                if (red < 0) {
                    red = 0;
                }
                if (green < 0) {
                    green = 0;
                }
                if (blue < 0) {
                    blue = 0;
                }
                this.gradients.add(new Color((Device)Display.getDefault(), red, green, blue));
                red += redStep;
                blue += blueStep;
                green += greenStep;
                ++i;
            }
        }
        catch (Throwable t) {
            MylarStatusHandler.log((Throwable)t, (String)"gradients failed");
        }
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Color getBase() {
        return ColorMap.COLOR_WHITE;
    }

    public static Color blend(List<Highlighter> highlighters, IInteractionElement info, boolean isLandmark) {
        int red = 0;
        int green = 0;
        int blue = 0;
        int num = highlighters.size();
        for (Highlighter highlighter : highlighters) {
            Color color = highlighter.getHighlight(info, isLandmark);
            red += color.getRed();
            green += color.getGreen();
            blue += color.getBlue();
        }
        return new Color((Device)Display.getDefault(), red / num, green / num, blue / num);
    }

    public boolean isGradient() {
        return this.isGradient;
    }

    public void setGradient(boolean isGradient) {
        this.isGradient = isGradient;
    }

    public Color getCore() {
        return this.core;
    }

    public void setCore(Color core) {
        this.core = core;
        this.initializeGradients();
        this.initializeHighlight();
    }

    public String getHighlightKind() {
        String res = VAL_DEFAULT;
        res = this.isGradient ? LABEL_GRADIENT : (this.isIntersection ? LABEL_INTERSECTION : LABEL_SOLID);
        return res;
    }

    public String externalizeToString() {
        if (this.core == null) {
            return VAL_DEFAULT;
        }
        Integer r = new Integer(this.core.getRed());
        Integer g = new Integer(this.core.getGreen());
        Integer b = new Integer(this.core.getBlue());
        return String.valueOf(r.toString()) + ";" + g.toString() + ";" + b.toString() + ";" + this.name + ";" + this.getHighlightKind();
    }

    private boolean initializeFromString(String attributes) {
        if (!VAL_DEFAULT.equals(attributes)) {
            String[] data = attributes.split(";");
            Integer r = new Integer(data[0]);
            Integer g = new Integer(data[1]);
            Integer b = new Integer(data[2]);
            this.core = new Color((Device)Display.getCurrent(), r.intValue(), g.intValue(), b.intValue());
            this.name = data[3];
            if (data[4].compareTo(LABEL_GRADIENT) == 0) {
                this.isGradient = true;
                this.isIntersection = false;
            } else if (data[4].compareTo(LABEL_INTERSECTION) == 0) {
                this.isGradient = false;
                this.isIntersection = true;
            } else {
                this.isGradient = false;
                this.isIntersection = false;
            }
            return true;
        }
        this.name = HighlighterList.DEFAULT_HIGHLIGHTER.getName();
        this.core = HighlighterList.DEFAULT_HIGHLIGHTER.getCore();
        return false;
    }
}

