/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.context.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.mylar.context.core.AbstractContextStructureBridge;
import org.eclipse.mylar.context.core.ContextCorePlugin;
import org.eclipse.mylar.context.core.IInteractionContext;
import org.eclipse.mylar.context.core.IInteractionContextListener;
import org.eclipse.mylar.context.core.IInteractionElement;
import org.eclipse.mylar.context.ui.ContextUiPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetUpdater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MylarWorkingSetManager
implements IWorkingSetUpdater,
IInteractionContextListener {
    private List<IWorkingSet> workingSets = new ArrayList<IWorkingSet>();

    public MylarWorkingSetManager() {
        ContextUiPlugin.getDefault().addWorkingSetManager(this);
    }

    public void add(IWorkingSet workingSet) {
        this.workingSets.add(workingSet);
    }

    public boolean remove(IWorkingSet workingSet) {
        return this.workingSets.remove(workingSet);
    }

    public boolean contains(IWorkingSet workingSet) {
        return this.workingSets.contains(workingSet);
    }

    public void dispose() {
    }

    public void contextActivated(IInteractionContext context) {
        this.updateWorkingSet();
    }

    public void contextDeactivated(IInteractionContext context) {
        this.updateWorkingSet();
    }

    public void contextCleared(IInteractionContext context) {
        this.updateWorkingSet();
    }

    public void interestChanged(List<IInteractionElement> nodes) {
        this.updateWorkingSet();
    }

    public void elementDeleted(IInteractionElement node) {
        this.updateWorkingSet();
    }

    public void landmarkAdded(IInteractionElement node) {
        this.updateWorkingSet();
    }

    public void landmarkRemoved(IInteractionElement node) {
        this.updateWorkingSet();
    }

    public void relationsChanged(IInteractionElement node) {
    }

    private void updateWorkingSet() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (MylarWorkingSetManager.this.workingSets.size() <= 0) {
                    return;
                }
                IWorkingSet set = (IWorkingSet)MylarWorkingSetManager.this.workingSets.get(0);
                set.setElements(new IAdaptable[0]);
                ArrayList<IAdaptable> elements = new ArrayList<IAdaptable>();
                MylarWorkingSetManager.getElementsFromTaskscape(elements);
                set.setElements(elements.toArray(new IAdaptable[elements.size()]));
            }
        });
    }

    public static void getElementsFromTaskscape(List<IAdaptable> elements) {
        for (IInteractionElement node : ContextCorePlugin.getContextManager().getInterestingDocuments()) {
            Object o;
            AbstractContextStructureBridge bridge = ContextCorePlugin.getDefault().getStructureBridge(node.getContentType());
            if (bridge.getContentType().equals("bugzilla") || !((o = bridge.getObjectForHandle(node.getHandleIdentifier())) instanceof IAdaptable)) continue;
            elements.add((IAdaptable)o);
        }
    }

    public IWorkingSet getWorkingSet() {
        return this.workingSets.get(0);
    }
}

