/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.context.ui;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylar.context.ui.ContextUiPlugin;
import org.eclipse.mylar.internal.context.ui.ContextUiPrefContstants;
import org.eclipse.mylar.internal.context.ui.MylarWorkingSetManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.dialogs.IWorkingSetPage;

public class MylarWorkingSetPage
extends WizardPage
implements IWorkingSetPage {
    private Text workingSetNameText;
    private IWorkingSet workingSet;
    public static final String WORKING_SET_NAME = "Mylar Task Context (for search)";

    public MylarWorkingSetPage() {
        super("org.eclipse.mylar.monitor.ui.workingSetPage", "Mylar Task Context Working Set", ContextUiPlugin.imageDescriptorFromPlugin((String)"org.eclipse.mylar.ui", (String)"icons/wizban/banner-prefs.gif"));
        this.setDescription("Create the Mylar Task Context working set.  It will be updated automatically to contain\nall of the resources related to the active task.");
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(256));
        this.setControl((Control)composite);
        Label label = new Label(composite, 64);
        label.setText("Name");
        GridData gd = new GridData(772);
        label.setLayoutData((Object)gd);
        this.workingSetNameText = new Text(composite, 2052);
        this.workingSetNameText.setLayoutData((Object)new GridData(768));
        this.workingSetNameText.setFocus();
        this.workingSetNameText.setEditable(false);
        this.workingSetNameText.setText(WORKING_SET_NAME);
        label = new Label(composite, 64);
        label.setText("");
        gd = new GridData(772);
        label.setLayoutData((Object)gd);
        label = new Label(composite, 64);
        label.setText("NOTE: this working set should only be used for searches.  Do not select it in the Package Explorer.");
        label.setFont(ContextUiPrefContstants.BOLD);
        gd = new GridData(772);
        label.setLayoutData((Object)gd);
        label = new Label(composite, 64);
        label.setText("");
        gd = new GridData(772);
        label.setLayoutData((Object)gd);
        Dialog.applyDialogFont((Control)composite);
    }

    public IWorkingSet getSelection() {
        return this.workingSet;
    }

    public void setSelection(IWorkingSet workingSet) {
    }

    public void finish() {
        IWorkingSetManager workingSetManager;
        String workingSetName = this.workingSetNameText.getText();
        ArrayList<IAdaptable> elements = new ArrayList<IAdaptable>(1);
        MylarWorkingSetManager.getElementsFromTaskscape(elements);
        if (this.workingSet == null && (this.workingSet = (workingSetManager = ContextUiPlugin.getDefault().getWorkbench().getWorkingSetManager()).getWorkingSet(workingSetName)) == null) {
            this.workingSet = workingSetManager.createWorkingSet(workingSetName, elements.toArray(new IAdaptable[elements.size()]));
        }
    }

    public boolean isPageComplete() {
        String workingSetName = this.workingSetNameText.getText();
        IWorkingSetManager workingSetManager = ContextUiPlugin.getDefault().getWorkbench().getWorkingSetManager();
        if (workingSetManager.getWorkingSet(workingSetName) != null) {
            this.setErrorMessage("Cannot create another Active Taskscape Working Set");
            return false;
        }
        return true;
    }
}

