/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.context.ui;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mylar.internal.tasks.ui.views.TaskKeyComparator;
import org.eclipse.mylar.internal.tasks.ui.views.TaskListTableSorter;
import org.eclipse.mylar.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylar.tasks.core.AbstractTaskContainer;
import org.eclipse.mylar.tasks.core.DateRangeContainer;
import org.eclipse.mylar.tasks.core.ITask;
import org.eclipse.mylar.tasks.core.ITaskListElement;
import org.eclipse.mylar.tasks.core.TaskArchive;
import org.eclipse.mylar.tasks.core.UncategorizedCategory;
import org.eclipse.mylar.tasks.ui.TasksUiPlugin;

public class TaskListInterestSorter
extends ViewerSorter {
    private TaskKeyComparator taskKeyComparator = new TaskKeyComparator();

    public int compare(Viewer compareViewer, Object o1, Object o2) {
        if (o1 instanceof AbstractTaskContainer && o2 instanceof TaskArchive) {
            return -1;
        }
        if (o2 instanceof AbstractTaskContainer && o1 instanceof TaskArchive) {
            return 1;
        }
        if (o1 instanceof DateRangeContainer) {
            if (o2 instanceof DateRangeContainer) {
                DateRangeContainer dateRangeTaskContainer1 = (DateRangeContainer)o1;
                DateRangeContainer dateRangeTaskContainer2 = (DateRangeContainer)o2;
                return -1 * dateRangeTaskContainer2.getStart().compareTo(dateRangeTaskContainer1.getStart());
            }
            if (o2 instanceof ITask) {
                return 1;
            }
            return -1;
        }
        if (o1 instanceof UncategorizedCategory && o2 instanceof AbstractTaskContainer) {
            return -1;
        }
        if (o1 instanceof AbstractTaskContainer && o2 instanceof UncategorizedCategory) {
            return 1;
        }
        if (o1 instanceof AbstractTaskContainer && o2 instanceof ITask) {
            return 1;
        }
        if (o1 instanceof AbstractTaskContainer || o1 instanceof AbstractRepositoryQuery) {
            if (o2 instanceof AbstractTaskContainer || o2 instanceof AbstractRepositoryQuery) {
                return ((ITaskListElement)o1).getSummary().compareToIgnoreCase(((ITaskListElement)o2).getSummary());
            }
            return -1;
        }
        if (o1 instanceof ITaskListElement) {
            if (o2 instanceof AbstractTaskContainer || o2 instanceof AbstractRepositoryQuery) {
                return -1;
            }
            if (o2 instanceof ITaskListElement) {
                ITaskListElement element1 = (ITaskListElement)o1;
                ITaskListElement element2 = (ITaskListElement)o2;
                ITask task1 = null;
                ITask task2 = null;
                if (element1 instanceof ITask) {
                    task1 = (ITask)element1;
                }
                if (element2 instanceof ITask) {
                    task2 = (ITask)element2;
                }
                if (task1 == null && task2 == null) {
                    return this.comparePrioritiesAndKeys(element1, element2);
                }
                if (task1 == null) {
                    return 1;
                }
                if (task2 == null) {
                    return -1;
                }
                int complete = this.compareCompleted(task1, task2);
                if (complete != 0) {
                    return complete;
                }
                int overdue = this.compareOverdue(task1, task2);
                if (overdue != 0) {
                    return overdue;
                }
                int thisWeek = this.compareThisWeek(task1, task2);
                if (thisWeek != 0) {
                    return thisWeek;
                }
                int today = this.compareToday(task1, task2);
                if (today != 0) {
                    return today;
                }
                return this.comparePrioritiesAndKeys(element1, element2);
            }
        }
        return 0;
    }

    private int compareOverdue(ITask task1, ITask task2) {
        if (task1.isPastReminder() && !task2.isPastReminder()) {
            return -1;
        }
        if (!task1.isPastReminder() && task2.isPastReminder()) {
            return 1;
        }
        return 0;
    }

    private int compareToday(ITask task1, ITask task2) {
        if (TasksUiPlugin.getTaskListManager().isScheduledForToday(task1) && !TasksUiPlugin.getTaskListManager().isScheduledForToday(task2)) {
            return -1;
        }
        if (!TasksUiPlugin.getTaskListManager().isScheduledForToday(task1) && TasksUiPlugin.getTaskListManager().isScheduledForToday(task2)) {
            return 1;
        }
        return 0;
    }

    private int compareThisWeek(ITask task1, ITask task2) {
        if (TasksUiPlugin.getTaskListManager().isScheduledForThisWeek(task1) && !TasksUiPlugin.getTaskListManager().isScheduledForThisWeek(task2)) {
            return 1;
        }
        if (!TasksUiPlugin.getTaskListManager().isScheduledForThisWeek(task1) && TasksUiPlugin.getTaskListManager().isScheduledForThisWeek(task2)) {
            return -1;
        }
        return 0;
    }

    private int compareCompleted(ITask task1, ITask task2) {
        if (task1.isCompleted() && !task2.isCompleted()) {
            return 1;
        }
        if (!task1.isCompleted() && task2.isCompleted()) {
            return -1;
        }
        return 0;
    }

    private int comparePrioritiesAndKeys(ITaskListElement element1, ITaskListElement element2) {
        int priority = this.comparePriorities(element1, element2);
        if (priority != 0) {
            return priority;
        }
        int description = this.compareKeys(element1, element2);
        if (description != 0) {
            return description;
        }
        return 0;
    }

    private int compareKeys(ITaskListElement element1, ITaskListElement element2) {
        String summary1 = TaskListTableSorter.getSortableSummaryFromElement((ITaskListElement)element1);
        String summary2 = TaskListTableSorter.getSortableSummaryFromElement((ITaskListElement)element2);
        return this.taskKeyComparator.compare(summary1, summary2);
    }

    private int comparePriorities(ITaskListElement element1, ITaskListElement element2) {
        return element1.getPriority().compareTo(element2.getPriority());
    }
}

