/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.context.ui.actions;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mylar.context.core.ContextCorePlugin;
import org.eclipse.mylar.context.ui.ContextUiPlugin;
import org.eclipse.mylar.context.ui.InterestFilter;
import org.eclipse.mylar.core.MylarStatusHandler;
import org.eclipse.mylar.internal.context.ui.ContextUiImages;
import org.eclipse.mylar.monitor.ui.MonitorUiPlugin;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFocusViewAction
extends Action
implements IViewActionDelegate,
IActionDelegate2,
ISelectionListener {
    private static final String ACTION_LABEL = "Apply Mylar";
    public static final String PREF_ID_PREFIX = "org.eclipse.mylar.ui.interest.filter.";
    protected String globalPrefId;
    protected IAction initAction = null;
    protected final InterestFilter interestFilter;
    protected IViewPart viewPart;
    protected Map<StructuredViewer, List<ViewerFilter>> previousFilters = new WeakHashMap<StructuredViewer, List<ViewerFilter>>();
    private boolean manageViewer = true;
    private boolean manageFilters = true;
    private boolean manageLinking = false;
    private boolean wasLinkingEnabled = false;
    private static Map<IViewPart, AbstractFocusViewAction> partMap = new WeakHashMap<IViewPart, AbstractFocusViewAction>();
    private final IWorkbenchListener WORKBENCH_LISTENER = new IWorkbenchListener(){

        public boolean preShutdown(IWorkbench workbench, boolean forced) {
            if (AbstractFocusViewAction.this.manageLinking) {
                AbstractFocusViewAction.this.setDefaultLinkingEnabled(AbstractFocusViewAction.this.wasLinkingEnabled);
            }
            List<StructuredViewer> viewers = AbstractFocusViewAction.this.getViewers();
            Set excludedFilters = AbstractFocusViewAction.this.getPreservedFilterClasses();
            for (StructuredViewer viewer : viewers) {
                if (!AbstractFocusViewAction.this.previousFilters.containsKey(viewer)) continue;
                for (ViewerFilter filter : AbstractFocusViewAction.this.previousFilters.get(viewer)) {
                    if (excludedFilters.contains(filter.getClass())) continue;
                    try {
                        viewer.addFilter(filter);
                    }
                    catch (Throwable t) {
                        MylarStatusHandler.fail((Throwable)t, (String)("Failed to restore filter: " + filter), (boolean)false);
                    }
                }
                AbstractFocusViewAction.this.previousFilters.remove(viewer);
            }
            return true;
        }

        public void postShutdown(IWorkbench workbench) {
        }
    };

    public static AbstractFocusViewAction getActionForPart(IViewPart part) {
        return partMap.get(part);
    }

    public IViewPart getPartForAction() {
        if (this.viewPart == null) {
            if (this instanceof IWorkbenchWindowActionDelegate) {
                if (!PlatformUI.getWorkbench().isClosing()) {
                    throw new RuntimeException("not supported on IWorkbenchWindowActionDelegate");
                }
            } else {
                throw new RuntimeException("error: viewPart is null");
            }
        }
        return this.viewPart;
    }

    public AbstractFocusViewAction(InterestFilter interestFilter, boolean manageViewer, boolean manageFilters, boolean manageLinking) {
        this.interestFilter = interestFilter;
        this.manageViewer = manageViewer;
        this.manageFilters = manageFilters;
        this.manageLinking = manageLinking;
        this.setText(ACTION_LABEL);
        this.setToolTipText(ACTION_LABEL);
        this.setImageDescriptor(ContextUiImages.INTEREST_FILTERING);
        PlatformUI.getWorkbench().addWorkbenchListener(this.WORKBENCH_LISTENER);
    }

    public void dispose() {
        partMap.remove(this.getPartForAction());
        if (this.viewPart != null && !PlatformUI.getWorkbench().isClosing()) {
            for (StructuredViewer viewer : this.getViewers()) {
                ContextUiPlugin.getDefault().getViewerManager().removeManagedViewer(viewer, (IWorkbenchPart)this.viewPart);
            }
        }
        MonitorUiPlugin.getDefault().removeWindowPostSelectionListener((ISelectionListener)this);
        PlatformUI.getWorkbench().removeWorkbenchListener(this.WORKBENCH_LISTENER);
    }

    public void init(IAction action) {
        this.initAction = action;
        this.setChecked(action.isChecked());
    }

    public void init(IViewPart view) {
        String id = view.getSite().getId();
        this.globalPrefId = PREF_ID_PREFIX + id;
        this.viewPart = view;
        partMap.put(view, this);
    }

    public void run(IAction action) {
        this.setChecked(action.isChecked());
        this.valueChanged(action, action.isChecked(), true);
    }

    public void update() {
        if (this.globalPrefId != null) {
            this.update(ContextUiPlugin.getDefault().getPreferenceStore().getBoolean(this.globalPrefId));
        }
    }

    public void update(boolean on) {
        this.valueChanged(this.initAction, on, false);
    }

    protected void valueChanged(IAction action, boolean on, boolean store) {
        if (PlatformUI.getWorkbench().isClosing()) {
            return;
        }
        boolean wasPaused = ContextCorePlugin.getContextManager().isContextCapturePaused();
        try {
            try {
                if (!wasPaused) {
                    ContextCorePlugin.getContextManager().setContextCapturePaused(true);
                }
                this.setChecked(on);
                action.setChecked(on);
                if (store && ContextCorePlugin.getDefault() != null) {
                    ContextUiPlugin.getDefault().getPreferenceStore().setValue(this.globalPrefId, on);
                }
                List<StructuredViewer> viewers = this.getViewers();
                for (StructuredViewer viewer : viewers) {
                    if (this.viewPart != null && !viewer.getControl().isDisposed() && this.manageViewer) {
                        ContextUiPlugin.getDefault().getViewerManager().addManagedViewer(viewer, (IWorkbenchPart)this.viewPart);
                    }
                    this.updateInterestFilter(on, viewer);
                }
                if (this.manageLinking) {
                    this.updateLinking(on);
                }
            }
            catch (Throwable t) {
                MylarStatusHandler.fail((Throwable)t, (String)("Could not install viewer manager on: " + this.globalPrefId), (boolean)false);
                if (!wasPaused) {
                    ContextCorePlugin.getContextManager().setContextCapturePaused(false);
                }
            }
        }
        finally {
            if (!wasPaused) {
                ContextCorePlugin.getContextManager().setContextCapturePaused(false);
            }
        }
    }

    private void updateLinking(boolean on) {
        if (on) {
            this.wasLinkingEnabled = this.isDefaultLinkingEnabled();
            this.setDefaultLinkingEnabled(false);
            MonitorUiPlugin.getDefault().addWindowPostSelectionListener((ISelectionListener)this);
        } else {
            MonitorUiPlugin.getDefault().removeWindowPostSelectionListener((ISelectionListener)this);
            this.setDefaultLinkingEnabled(this.wasLinkingEnabled);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (this.manageLinking && selection instanceof ITextSelection && part instanceof IEditorPart) {
            try {
                ISelection currentSelection;
                StructuredViewer viewer;
                ITextSelection textSelection;
                ISelection toSelect;
                List<StructuredViewer> viewers = this.getViewers();
                if (viewers.size() == 1 && (toSelect = this.resolveSelection((IEditorPart)part, textSelection = (ITextSelection)selection, viewer = this.getViewers().get(0))) != null && !selection.equals(currentSelection = viewer.getSelection())) {
                    this.select(viewer, toSelect);
                }
            }
            catch (Throwable throwable) {}
        }
    }

    protected void select(StructuredViewer viewer, ISelection selection) {
        viewer.setSelection(selection, true);
    }

    protected ISelection resolveSelection(IEditorPart part, ITextSelection selection, StructuredViewer viewer) throws CoreException {
        return null;
    }

    protected void setDefaultLinkingEnabled(boolean on) {
    }

    protected boolean isDefaultLinkingEnabled() {
        return false;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void updateInterestFilter(boolean on, StructuredViewer viewer) {
        if (viewer != null) {
            if (on) {
                this.installInterestFilter(viewer);
                ContextUiPlugin.getDefault().getViewerManager().addFilteredViewer(viewer);
            } else {
                ContextUiPlugin.getDefault().getViewerManager().removeFilteredViewer(viewer);
                this.uninstallInterestFilter(viewer);
            }
        }
    }

    public abstract List<StructuredViewer> getViewers();

    private Set<Class<?>> getPreservedFilterClasses() {
        return ContextUiPlugin.getDefault().getPreservedFilterClasses(this.viewPart.getSite().getId());
    }

    protected boolean installInterestFilter(StructuredViewer viewer) {
        if (viewer == null) {
            MylarStatusHandler.log((String)"The viewer to install InterestFilter is null", (Object)((Object)this));
            return false;
        }
        if (viewer.getControl().isDisposed() && this.manageViewer) {
            return false;
        }
        try {
            viewer.getControl().setRedraw(false);
            this.previousFilters.put(viewer, Arrays.asList(viewer.getFilters()));
            if (this.viewPart != null && this.manageFilters) {
                Set<Class<?>> excludedFilters = this.getPreservedFilterClasses();
                for (ViewerFilter filter : this.previousFilters.get(viewer)) {
                    if (excludedFilters.contains(filter.getClass())) continue;
                    try {
                        viewer.removeFilter(filter);
                    }
                    catch (Throwable t) {
                        MylarStatusHandler.fail((Throwable)t, (String)("Failed to remove filter: " + filter), (boolean)false);
                    }
                }
            }
            viewer.addFilter((ViewerFilter)this.interestFilter);
            if (viewer instanceof TreeViewer) {
                ((TreeViewer)viewer).expandAll();
            }
            viewer.getControl().setRedraw(true);
            return true;
        }
        catch (Throwable t) {
            t.printStackTrace();
            MylarStatusHandler.fail((Throwable)t, (String)("Could not install viewer filter on: " + this.globalPrefId), (boolean)false);
            return false;
        }
    }

    protected void uninstallInterestFilter(StructuredViewer viewer) {
        if (viewer == null) {
            MylarStatusHandler.log((String)"Could not uninstall interest filter", (Object)((Object)this));
            return;
        }
        if (viewer.getControl().isDisposed()) {
            ContextUiPlugin.getDefault().getViewerManager().removeManagedViewer(viewer, (IWorkbenchPart)this.viewPart);
            return;
        }
        viewer.getControl().setRedraw(false);
        if (this.viewPart != null && this.manageFilters) {
            Set<Class<?>> excludedFilters = this.getPreservedFilterClasses();
            if (this.previousFilters.containsKey(viewer)) {
                for (ViewerFilter filter : this.previousFilters.get(viewer)) {
                    if (excludedFilters.contains(filter.getClass())) continue;
                    try {
                        viewer.addFilter(filter);
                    }
                    catch (Throwable t) {
                        MylarStatusHandler.fail((Throwable)t, (String)("Failed to remove filter: " + filter), (boolean)false);
                    }
                }
                this.previousFilters.remove(viewer);
            }
        }
        for (ViewerFilter filter : Arrays.asList(viewer.getFilters())) {
            if (!(filter instanceof InterestFilter)) continue;
            viewer.removeFilter((ViewerFilter)this.interestFilter);
        }
        viewer.getControl().setRedraw(true);
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public String getGlobalPrefId() {
        return this.globalPrefId;
    }

    public InterestFilter getInterestFilter() {
        return this.interestFilter;
    }
}

