/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.context.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylar.context.core.AbstractContextStructureBridge;
import org.eclipse.mylar.context.core.ContextCorePlugin;
import org.eclipse.mylar.context.core.IInteractionElement;
import org.eclipse.mylar.internal.context.ui.UiUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ObjectPluginAction;

public abstract class AbstractInterestManipulationAction
implements IViewActionDelegate,
IWorkbenchWindowActionDelegate {
    private static final String MESSAGE_NO_CONTEXT = "No task context is active, or element not found in context";
    public static final String SOURCE_ID = "org.eclipse.mylar.ui.interest.user";
    protected IViewPart view;
    protected IWorkbenchWindow window;

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void init(IViewPart view) {
        this.view = view;
    }

    protected abstract boolean isIncrement();

    public void run(IAction action) {
        if (!ContextCorePlugin.getContextManager().isContextActive()) {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Mylar Information", (String)MESSAGE_NO_CONTEXT);
            return;
        }
        boolean increment = this.isIncrement();
        ISelection currentSelection = null;
        if (action instanceof ObjectPluginAction) {
            ObjectPluginAction objectAction = (ObjectPluginAction)action;
            currentSelection = objectAction.getSelection();
        } else {
            try {
                currentSelection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
            }
            catch (Exception exception) {}
        }
        if (currentSelection instanceof StructuredSelection) {
            StructuredSelection selection = (StructuredSelection)currentSelection;
            for (Object object : selection.toList()) {
                boolean manipulated;
                IInteractionElement node = null;
                if (object instanceof IInteractionElement) {
                    node = (IInteractionElement)object;
                } else {
                    AbstractContextStructureBridge bridge = ContextCorePlugin.getDefault().getStructureBridge(object);
                    String handle = bridge.getHandleIdentifier(object);
                    node = ContextCorePlugin.getContextManager().getElement(handle);
                }
                if (node == null) continue;
                if (!this.isIncrement()) {
                    try {
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite().getSelectionProvider().setSelection(null);
                    }
                    catch (Exception exception) {}
                }
                if (manipulated = ContextCorePlugin.getContextManager().manipulateInterestForElement(node, increment, false, SOURCE_ID)) continue;
                UiUtil.displayInterestManipulationFailure();
            }
        } else {
            IInteractionElement node = ContextCorePlugin.getContextManager().getActiveElement();
            if (node != null) {
                boolean manipulated = ContextCorePlugin.getContextManager().manipulateInterestForElement(node, increment, false, SOURCE_ID);
                if (!manipulated) {
                    UiUtil.displayInterestManipulationFailure();
                }
            } else {
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Mylar Information", (String)MESSAGE_NO_CONTEXT);
            }
        }
    }

    public void dispose() {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

