/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.context.ui.actions;

import java.io.File;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylar.context.core.ContextCorePlugin;
import org.eclipse.mylar.internal.context.ui.actions.TaskContextAction;
import org.eclipse.mylar.internal.tasks.ui.actions.TaskSelectionDialog;
import org.eclipse.mylar.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylar.tasks.core.ITask;
import org.eclipse.mylar.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

public class ContextCopyAction
extends TaskContextAction {
    private static final String OPEN_TASK_ACTION_DIALOG_SETTINGS = "open.task.action.dialog.settings";

    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        this.run(this.getSelectedTask(this.selection));
    }

    public void run(ITask sourceTask) {
        if (sourceTask == null) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Mylar Information", (String)"No source task selected.");
        }
        TaskSelectionDialog dialog = new TaskSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        dialog.setTitle("Select Target Task");
        IDialogSettings settings = TasksUiPlugin.getDefault().getDialogSettings();
        IDialogSettings dlgSettings = settings.getSection(OPEN_TASK_ACTION_DIALOG_SETTINGS);
        if (dlgSettings == null) {
            dlgSettings = settings.addNewSection(OPEN_TASK_ACTION_DIALOG_SETTINGS);
        }
        dialog.setDialogBoundsSettings(dlgSettings, 3);
        int ret = dialog.open();
        if (ret != 0) {
            return;
        }
        Object result = dialog.getFirstResult();
        ITask targetTask = null;
        if (result instanceof ITask) {
            targetTask = (ITask)result;
        }
        if (targetTask != null) {
            TasksUiPlugin.getTaskListManager().deactivateAllTasks();
            File contextFile = ContextCorePlugin.getContextManager().getFileForContext(sourceTask.getHandleIdentifier());
            if (targetTask.equals(sourceTask)) {
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Mylar Information", (String)"Target task can not be the same as source task.");
            } else if (!contextFile.exists()) {
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Mylar Information", (String)"Source task does not have a context.");
            } else {
                ContextCorePlugin.getContextManager().transferContextAndActivate(targetTask.getHandleIdentifier(), contextFile);
                TasksUiPlugin.getTaskListManager().activateTask(targetTask);
                TaskListView view = TaskListView.getFromActivePerspective();
                if (view != null) {
                    view.refreshAndFocus(false);
                }
            }
        } else {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Mylar Information", (String)"No target task selected.");
        }
    }
}

