/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.context.ui.editors;

import org.eclipse.mylar.context.core.ContextCorePlugin;
import org.eclipse.mylar.internal.context.ui.editors.ContextEditorFormPage;
import org.eclipse.mylar.internal.context.ui.editors.ContextEditorInput;
import org.eclipse.mylar.tasks.core.ITask;
import org.eclipse.mylar.tasks.ui.editors.ITaskEditorFactory;
import org.eclipse.mylar.tasks.ui.editors.RepositoryTaskEditorInput;
import org.eclipse.mylar.tasks.ui.editors.TaskEditor;
import org.eclipse.mylar.tasks.ui.editors.TaskEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.editor.FormEditor;

public class ContextEditorFactory
implements ITaskEditorFactory {
    private static final String LABEL = "Context";

    public boolean canCreateEditorFor(ITask task) {
        return task != null && ContextCorePlugin.getContextManager().hasContext(task.getHandleIdentifier());
    }

    public boolean canCreateEditorFor(IEditorInput input) {
        if (input instanceof RepositoryTaskEditorInput) {
            RepositoryTaskEditorInput repositoryTaskEditorInput = (RepositoryTaskEditorInput)input;
            return repositoryTaskEditorInput.getRepositoryTask() != null;
        }
        return input instanceof TaskEditorInput;
    }

    public IEditorPart createEditor(TaskEditor parentEditor, IEditorInput editorInput) {
        ContextEditorFormPage formPage = new ContextEditorFormPage((FormEditor)parentEditor, "org.eclipse.mylar.context.ui.editor.context", LABEL);
        return formPage;
    }

    public IEditorInput createEditorInput(ITask task) {
        return new ContextEditorInput(task);
    }

    public String getTitle() {
        return LABEL;
    }

    public boolean providesOutline() {
        return false;
    }
}

