/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.context.ui.preferences;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.mylar.context.ui.ContextUiPlugin;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class ContextUiPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
SelectionListener {
    private Button autoEnableExplorerFilter = null;
    private Button manageEditorsButton = null;
    private Button managePerspectivesButton = null;
    private Button manageExpansionButton = null;

    public ContextUiPreferencePage() {
        this.setPreferenceStore(ContextUiPlugin.getDefault().getPreferenceStore());
        this.setTitle("Mylar");
    }

    protected Control createContents(Composite parent) {
        Composite entryTable = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 4;
        entryTable.setLayout((Layout)layout);
        this.createUiManagementSection(entryTable);
        return entryTable;
    }

    public void init(IWorkbench workbench) {
    }

    public void widgetDefaultSelected(SelectionEvent se) {
        this.widgetSelected(se);
    }

    public void widgetSelected(SelectionEvent se) {
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("org.eclipse.mylar.context.ui.navigators.filter.auto.enable", this.autoEnableExplorerFilter.getSelection());
        this.getPreferenceStore().setValue("org.eclipse.mylar.ui.interest.highlighters", ContextUiPlugin.getDefault().getHighlighterList().externalizeToString());
        this.getPreferenceStore().setValue("org.eclipse.mylar.ide.ui.editors.auto.manage", this.manageEditorsButton.getSelection());
        this.getPreferenceStore().setValue("org.eclipse.mylar.ide.ui.perspectives.auto.manage", this.managePerspectivesButton.getSelection());
        this.getPreferenceStore().setValue("org.eclipse.mylar.ide.ui.expansion.auto.manage", this.manageExpansionButton.getSelection());
        return true;
    }

    public boolean performCancel() {
        this.autoEnableExplorerFilter.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylar.context.ui.navigators.filter.auto.enable"));
        return true;
    }

    public void performDefaults() {
        super.performDefaults();
    }

    private void createUiManagementSection(Composite parent) {
        Group group = new Group(parent, 16);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(768));
        group.setText("UI Management");
        this.managePerspectivesButton = new Button((Composite)group, 32);
        this.managePerspectivesButton.setText("Open last used perspective on task activation");
        this.managePerspectivesButton.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylar.ide.ui.perspectives.auto.manage"));
        this.autoEnableExplorerFilter = new Button((Composite)group, 32);
        this.autoEnableExplorerFilter.setText("Toggle focused mode on navigator views when task activated");
        this.autoEnableExplorerFilter.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylar.context.ui.navigators.filter.auto.enable"));
        this.manageEditorsButton = new Button((Composite)group, 32);
        this.manageEditorsButton.setText("Manage open editors with task context (Recommended)");
        this.manageEditorsButton.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylar.ide.ui.editors.auto.manage"));
        String prefName = WorkbenchMessages.WorkbenchPreference_reuseEditors;
        if (this.getContainer() instanceof IWorkbenchPreferenceContainer) {
            String message = "<a>''{0}''</a> \"" + prefName + "\" will turn off when task activated";
            new PreferenceLinkArea((Composite)group, 0, "org.eclipse.ui.preferencePages.Editors", message, (IWorkbenchPreferenceContainer)this.getContainer(), null);
        }
        this.manageExpansionButton = new Button((Composite)group, 32);
        this.manageExpansionButton.setText("Automatically maintain expansion of focused tree views (Recommended)");
        this.manageExpansionButton.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylar.ide.ui.expansion.auto.manage"));
    }
}

