/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.context.ui.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylar.context.core.AbstractContextStructureBridge;
import org.eclipse.mylar.context.core.ContextCorePlugin;
import org.eclipse.mylar.context.core.IInteractionElement;
import org.eclipse.mylar.context.core.IInteractionRelation;
import org.eclipse.mylar.internal.context.core.InteractionContextRelation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IViewSite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextContentProvider
implements IStructuredContentProvider,
ITreeContentProvider {
    private IViewSite site = null;
    private Tree tree;
    private Shell shell = null;
    private boolean landmarkOnlyMode;

    public ContextContentProvider(Tree tree, IViewSite site, boolean landmarkOnlyMode) {
        this.tree = tree;
        this.site = site;
        this.landmarkOnlyMode = landmarkOnlyMode;
    }

    public ContextContentProvider(Shell shell, boolean landmarkOnlyMode) {
        this.shell = shell;
        this.landmarkOnlyMode = landmarkOnlyMode;
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public Object[] getElements(Object parent) {
        if (this.matchesParent(parent)) {
            ArrayList<IInteractionElement> nodes;
            if (this.landmarkOnlyMode) {
                List landmarks = ContextCorePlugin.getContextManager().getActiveLandmarks();
                nodes = new ArrayList<IInteractionElement>();
                for (IInteractionElement node : landmarks) {
                    if (node.getContentType().equals("*") || node.getInterest().isPredicted()) continue;
                    nodes.add(node);
                }
            } else {
                nodes = ContextCorePlugin.getContextManager().getActiveContext().getAllElements();
            }
            ArrayList<Object> resolvedNodes = new ArrayList<Object>();
            for (IInteractionElement node : nodes) {
                AbstractContextStructureBridge bridge = ContextCorePlugin.getDefault().getStructureBridge(node.getContentType());
                Object object = bridge.getObjectForHandle(node.getHandleIdentifier());
                if (object == null) continue;
                resolvedNodes.add(object);
            }
            return resolvedNodes.toArray();
        }
        return this.getChildren(parent);
    }

    private boolean matchesParent(Object parent) {
        if (this.site != null && parent.equals(this.site)) {
            return true;
        }
        return this.shell != null && parent.equals(this.shell);
    }

    public Object getParent(Object child) {
        return null;
    }

    public Object[] getChildren(Object parent) {
        IInteractionElement node;
        if (parent == null) {
            return new Object[0];
        }
        if (parent instanceof InteractionContextRelation) {
            IInteractionRelation edge = (IInteractionRelation)parent;
            IInteractionElement source = ContextCorePlugin.getContextManager().getElement(((IInteractionRelation)parent).getSource().getHandleIdentifier());
            return this.getAllTagetsForSource(source, edge.getRelationshipHandle());
        }
        if (parent instanceof IInteractionElement) {
            node = (IInteractionElement)parent;
        } else {
            AbstractContextStructureBridge bridge = ContextCorePlugin.getDefault().getStructureBridge(parent);
            node = ContextCorePlugin.getContextManager().getElement(bridge.getHandleIdentifier(parent));
        }
        if (node != null) {
            return this.getAllEdgeTypes(node.getRelations());
        }
        return new Object[0];
    }

    private boolean isRootItem(Object object) {
        boolean isRootItem = false;
        TreeItem[] items = this.tree.getItems();
        int i = 0;
        while (i < items.length) {
            TreeItem item = items[i];
            if (object.equals(item.getData())) {
                isRootItem = true;
            }
            ++i;
        }
        return isRootItem;
    }

    private Object[] getAllTagetsForSource(IInteractionElement source, String kind) {
        Collection edges = source.getRelations();
        ArrayList<Object> targets = new ArrayList<Object>();
        for (InteractionContextRelation edge : edges) {
            if (!edge.getRelationshipHandle().equals(kind)) continue;
            IInteractionElement target = edge.getTarget();
            AbstractContextStructureBridge bridge = ContextCorePlugin.getDefault().getStructureBridge(target.getContentType());
            Object object = bridge.getObjectForHandle(target.getHandleIdentifier());
            if (object == null) continue;
            targets.add(object);
        }
        return targets.toArray();
    }

    private Object[] getAllEdgeTypes(Collection<InteractionContextRelation> edges) {
        HashMap<String, IInteractionRelation> map = new HashMap<String, IInteractionRelation>();
        for (IInteractionRelation iInteractionRelation : edges) {
            IInteractionRelation edgeType = (IInteractionRelation)map.get(iInteractionRelation.getRelationshipHandle());
            if (edgeType != null) continue;
            edgeType = iInteractionRelation;
            map.put(iInteractionRelation.getRelationshipHandle(), edgeType);
        }
        Object[] objectArray = new Object[map.size()];
        int index = 0;
        for (IInteractionRelation value : map.values()) {
            objectArray[index] = value;
            ++index;
        }
        return objectArray;
    }

    public boolean hasChildren(Object parent) {
        if (parent instanceof IInteractionRelation) {
            return true;
        }
        return this.isRootItem(parent);
    }
}

