/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.context.ui.views;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.mylar.context.core.AbstractContextStructureBridge;
import org.eclipse.mylar.context.core.ContextCorePlugin;
import org.eclipse.mylar.context.core.IInteractionElement;
import org.eclipse.mylar.context.core.IInteractionObject;
import org.eclipse.mylar.context.ui.ContextUiPlugin;
import org.eclipse.swt.graphics.Image;

public class DelegatingContextLabelProvider
implements ILabelProvider {
    private static boolean qualifyNamesMode = false;

    public static boolean isQualifyNamesMode() {
        return qualifyNamesMode;
    }

    public static void setQualifyNamesMode(boolean qualify) {
        qualifyNamesMode = qualify;
    }

    public Image getImage(Object element) {
        if (element instanceof IInteractionObject) {
            ILabelProvider provider = ContextUiPlugin.getDefault().getContextLabelProvider(((IInteractionObject)element).getContentType());
            return provider.getImage(element);
        }
        AbstractContextStructureBridge bridge = ContextCorePlugin.getDefault().getStructureBridge(element);
        ILabelProvider provider = ContextUiPlugin.getDefault().getContextLabelProvider(bridge.getContentType());
        if (provider != null) {
            return provider.getImage(element);
        }
        return null;
    }

    public String getText(Object object) {
        if (object instanceof IInteractionObject) {
            IInteractionObject element = (IInteractionObject)object;
            ILabelProvider provider = ContextUiPlugin.getDefault().getContextLabelProvider(element.getContentType());
            if (ContextUiPlugin.getDefault().isDecorateInterestMode()) {
                return String.valueOf(provider.getText((Object)element)) + " [" + element.getInterest().getValue() + "]";
            }
            return provider.getText((Object)element);
        }
        AbstractContextStructureBridge bridge = ContextCorePlugin.getDefault().getStructureBridge(object);
        ILabelProvider provider = ContextUiPlugin.getDefault().getContextLabelProvider(bridge.getContentType());
        if (provider != null) {
            if (ContextUiPlugin.getDefault().isDecorateInterestMode()) {
                IInteractionElement element = ContextCorePlugin.getContextManager().getElement(bridge.getHandleIdentifier(object));
                return String.valueOf(provider.getText(object)) + " [" + element.getInterest().getValue() + "]";
            }
            return provider.getText(object);
        }
        return "? " + object;
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

