/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.doc.internal.dialogs;

import java.util.Collection;
import java.util.List;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylar.internal.tasks.ui.TaskListColorsAndFonts;
import org.eclipse.mylar.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylar.internal.tasks.ui.views.TaskElementLabelProvider;
import org.eclipse.mylar.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylar.tasks.core.ITaskListElement;
import org.eclipse.mylar.tasks.core.Task;
import org.eclipse.mylar.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylar.tasks.ui.TasksUiPlugin;
import org.eclipse.mylar.tasks.ui.TasksUiUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.internal.themes.ColorsAndFontsPreferencePage;
import org.eclipse.ui.themes.IThemeManager;

public class UiLegendDialog
extends PopupDialog {
    private FormToolkit toolkit;
    private ScrolledForm form;
    private TaskElementLabelProvider labelProvider = new TaskElementLabelProvider();
    private IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();

    public UiLegendDialog(Shell parent) {
        super(parent, 16392, false, false, false, false, null, null);
    }

    protected Control createContents(Composite parent) {
        this.getShell().setBackground(this.getShell().getDisplay().getSystemColor(15));
        return this.createDialogArea(parent);
    }

    public int open() {
        int open = super.open();
        this.getShell().setFocus();
        return open;
    }

    protected final Control createDialogArea(Composite parent) {
        this.getShell().setText("Mylar UI Legend");
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.form = this.toolkit.createScrolledForm(parent);
        GridLayout formLayout = new GridLayout();
        formLayout.numColumns = 1;
        this.form.getBody().setLayout((Layout)formLayout);
        Label image = null;
        Section section = this.toolkit.createSection(this.form.getBody(), 128);
        section.setText("Mylar UI Legend                                                        ");
        Composite sectionClient = this.toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginTop = 0;
        sectionClient.setLayout((Layout)layout);
        Composite buttonsComposite = this.toolkit.createComposite((Composite)section);
        GridLayout buttonsLayout = new GridLayout();
        buttonsLayout.verticalSpacing = 0;
        buttonsLayout.verticalSpacing = 0;
        buttonsLayout.marginHeight = 0;
        buttonsLayout.marginWidth = 0;
        buttonsComposite.setLayout((Layout)buttonsLayout);
        section.setTextClient((Control)buttonsComposite);
        ImageHyperlink closeHyperlink = this.toolkit.createImageHyperlink(buttonsComposite, 0);
        closeHyperlink.setLayout((Layout)buttonsLayout);
        closeHyperlink.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.NOTIFICATION_CLOSE));
        closeHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                UiLegendDialog.this.close();
            }
        });
        Composite tasksComposite = this.toolkit.createComposite(this.form.getBody());
        tasksComposite.setLayout((Layout)new GridLayout(2, false));
        section = this.toolkit.createSection(tasksComposite, 256);
        section.setText("Tasks");
        sectionClient = this.toolkit.createComposite((Composite)section);
        this.setSectionLayout(sectionClient, section, false);
        image = this.toolkit.createLabel(sectionClient, "");
        image.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.TASK));
        this.toolkit.createLabel(sectionClient, "Task                       ");
        image = this.toolkit.createLabel(sectionClient, "");
        image.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.CATEGORY));
        this.toolkit.createLabel(sectionClient, "Category");
        image = this.toolkit.createLabel(sectionClient, "");
        image.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.QUERY));
        this.toolkit.createLabel(sectionClient, "Query");
        image = this.toolkit.createLabel(sectionClient, "");
        image.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.CALENDAR));
        this.toolkit.createLabel(sectionClient, "Date range");
        image = this.toolkit.createLabel(sectionClient, "");
        image.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.BLANK));
        section = this.toolkit.createSection(tasksComposite, 256);
        section.setText("Priorities                       ");
        sectionClient = this.toolkit.createComposite((Composite)section);
        this.setSectionLayout(sectionClient, section, false);
        image = this.toolkit.createLabel(sectionClient, "");
        image.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.PRIORITY_1));
        this.toolkit.createLabel(sectionClient, Task.PriorityLevel.P1.getDescription());
        image = this.toolkit.createLabel(sectionClient, "");
        image.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.PRIORITY_2));
        this.toolkit.createLabel(sectionClient, Task.PriorityLevel.P2.getDescription());
        image = this.toolkit.createLabel(sectionClient, "");
        image.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.PRIORITY_3));
        this.toolkit.createLabel(sectionClient, String.valueOf(Task.PriorityLevel.P3.getDescription()) + " (default)");
        image = this.toolkit.createLabel(sectionClient, "");
        image.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.PRIORITY_4));
        this.toolkit.createLabel(sectionClient, Task.PriorityLevel.P4.getDescription());
        image = this.toolkit.createLabel(sectionClient, "");
        image.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.PRIORITY_5));
        this.toolkit.createLabel(sectionClient, Task.PriorityLevel.P5.getDescription());
        section = this.toolkit.createSection(this.form.getBody(), 256);
        section.setText("Task Activity                                                                   ");
        sectionClient = this.toolkit.createComposite((Composite)section);
        this.setSectionLayout(sectionClient, section, false);
        image = this.toolkit.createLabel(sectionClient, "");
        image.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.TASK));
        Label labelOverdue = this.toolkit.createLabel(sectionClient, "Past scheduled date");
        labelOverdue.setForeground(this.themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylar.tasklist.ui.colors.foreground.overdue"));
        image = this.toolkit.createLabel(sectionClient, "");
        image.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.TASK));
        Label labelToday = this.toolkit.createLabel(sectionClient, "Scheduled for today");
        labelToday.setForeground(this.themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylar.tasklist.ui.colors.foreground.today.scheduled"));
        image = this.toolkit.createLabel(sectionClient, "");
        image.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.TASK));
        Label labelCompleted = this.toolkit.createLabel(sectionClient, "Completed");
        labelCompleted.setFont(TaskListColorsAndFonts.STRIKETHROUGH);
        labelCompleted.setForeground(this.themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylar.tasklist.ui.colors.foreground.completed"));
        image = this.toolkit.createLabel(sectionClient, "");
        image.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.TASK));
        Label labelCompletedToday = this.toolkit.createLabel(sectionClient, "Completed today");
        labelCompletedToday.setFont(TaskListColorsAndFonts.STRIKETHROUGH);
        labelCompletedToday.setForeground(this.themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylar.tasklist.ui.colors.foreground.today.completed"));
        image = this.toolkit.createLabel(sectionClient, "");
        image.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.OVERLAY_HAS_DUE));
        this.toolkit.createLabel(sectionClient, "Due date set");
        image = this.toolkit.createLabel(sectionClient, "");
        image.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.OVERLAY_OVER_DUE));
        this.toolkit.createLabel(sectionClient, "Due date past");
        image = this.toolkit.createLabel(sectionClient, "");
        image.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.BLANK));
        Hyperlink adjust = this.toolkit.createHyperlink(sectionClient, "Adjust Colors and Fonts...", 0);
        adjust.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                ColorsAndFontsPreferencePage page = new ColorsAndFontsPreferencePage();
                page.init(PlatformUI.getWorkbench());
                TasksUiUtil.showPreferencePage((String)"org.eclipse.ui.preferencePages.ColorsAndFonts", (IPreferencePage)page);
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
        section = this.toolkit.createSection(this.form.getBody(), 256);
        section.setText("Context                                                                            ");
        sectionClient = this.toolkit.createComposite((Composite)section);
        this.setSectionLayout(sectionClient, section, false);
        image = this.toolkit.createLabel(sectionClient, "");
        image.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.TASK_INACTIVE));
        this.toolkit.createLabel(sectionClient, "Inactive task with no context");
        image = this.toolkit.createLabel(sectionClient, "");
        image.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.TASK_INACTIVE_CONTEXT));
        this.toolkit.createLabel(sectionClient, "Inactive task with context");
        image = this.toolkit.createLabel(sectionClient, "");
        image.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.TASK_ACTIVE));
        this.toolkit.createLabel(sectionClient, "Active task");
        section = this.toolkit.createSection(this.form.getBody(), 256);
        section.setText("Synchronization                                                             ");
        sectionClient = this.toolkit.createComposite((Composite)section);
        this.setSectionLayout(sectionClient, section, true);
        image = this.toolkit.createLabel(sectionClient, "");
        image.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.OVERLAY_INCOMMING_NEW));
        this.toolkit.createLabel(sectionClient, "New task, open to view");
        image = this.toolkit.createLabel(sectionClient, "");
        image.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.OVERLAY_INCOMMING));
        this.toolkit.createLabel(sectionClient, "Incoming changes, open to view");
        image = this.toolkit.createLabel(sectionClient, "");
        image.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.OVERLAY_OUTGOING));
        this.toolkit.createLabel(sectionClient, "Outgoing changes");
        image = this.toolkit.createLabel(sectionClient, "");
        image.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.OVERLAY_WARNING));
        this.toolkit.createLabel(sectionClient, "Synchronization failed, mouse over for details");
        image = this.toolkit.createLabel(sectionClient, "");
        image.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.OVERLAY_CONFLICT));
        this.toolkit.createLabel(sectionClient, "Conflicting changes, need to synchronize");
        Composite connectorComposite = this.toolkit.createComposite(this.form.getBody());
        connectorComposite.setLayout((Layout)new GridLayout(2, false));
        Collection connectors = TasksUiPlugin.getRepositoryManager().getRepositoryConnectors();
        for (AbstractRepositoryConnector connector : connectors) {
            AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getRepositoryUi((String)connector.getRepositoryType());
            List elements = connectorUi.getLegendItems();
            if (elements.isEmpty()) continue;
            section = this.toolkit.createSection(connectorComposite, 256);
            String label = connector.getLabel();
            int parenIndex = label.indexOf(40);
            if (parenIndex != -1) {
                label = label.substring(0, parenIndex);
            }
            section.setText("Connector: " + label + " ");
            sectionClient = this.toolkit.createComposite((Composite)section);
            this.setSectionLayout(sectionClient, section, true);
            for (ITaskListElement taskListElement : elements) {
                image = this.toolkit.createLabel(sectionClient, "");
                image.setImage(this.labelProvider.getImage((Object)taskListElement));
                this.toolkit.createLabel(sectionClient, taskListElement.getSummary());
            }
        }
        this.form.pack();
        return parent;
    }

    private GridLayout setSectionLayout(Composite sectionClient, Section section, boolean extraPadding) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.verticalSpacing = 0;
        if (extraPadding) {
            layout.verticalSpacing = 5;
            layout.horizontalSpacing = 8;
        } else {
            layout.horizontalSpacing = 5;
            layout.verticalSpacing = 1;
        }
        layout.marginHeight = 0;
        layout.marginTop = 0;
        sectionClient.setLayout((Layout)layout);
        section.setClient((Control)sectionClient);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalSpan = 2;
        sectionClient.setLayoutData((Object)gridData);
        return layout;
    }
}

