/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.monitor.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mylar.monitor.core.IActivityTimerListener;

public class ActivityTimerThread
extends Thread
implements Runnable {
    private static final int SECOND = 1000;
    public static final int DEFAULT_SLEEP_INTERVAL = 5000;
    private int sleepInterval;
    private int timeout = 0;
    private int elapsed = 0;
    private List<IActivityTimerListener> listeners = new ArrayList<IActivityTimerListener>();
    private boolean suspended = false;
    boolean killed = false;

    public ActivityTimerThread(int timeoutInMillis, int sleepInterval) {
        this.sleepInterval = sleepInterval;
        this.setTimeoutMillis(timeoutInMillis);
    }

    public ActivityTimerThread(int millis) {
        this(millis, 5000);
    }

    public boolean addListener(IActivityTimerListener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(IActivityTimerListener listener) {
        return this.listeners.remove(listener);
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        try {
            ** GOTO lbl14
            {
                this.elapsed += this.sleepInterval;
                ActivityTimerThread.sleep(this.sleepInterval);
                do {
                    if (this.elapsed < this.timeout && !this.killed) continue block2;
                    if (this.elapsed >= this.timeout && !this.killed) {
                        if (!this.suspended) {
                            for (IActivityTimerListener listener : this.listeners) {
                                listener.fireInactive();
                            }
                        }
                        this.elapsed = 0;
                    }
                    ActivityTimerThread.sleep(this.sleepInterval);
lbl14:
                    // 2 sources

                } while (!this.killed);
            }
        }
        catch (InterruptedException v0) {}
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void setSuspended(boolean suspended) {
        this.suspended = suspended;
    }

    public void kill() {
        this.killed = true;
    }

    public void resetTimer() {
        this.suspended = false;
        this.elapsed = 0;
    }

    public int getTimeoutMillis() {
        return this.timeout;
    }

    public void setTimeoutMillis(int timeoutInMillis) {
        this.timeout = timeoutInMillis;
        if (this.sleepInterval > timeoutInMillis) {
            this.sleepInterval = timeoutInMillis - 1;
        }
    }
}

