/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.monitor.core;

import java.util.Calendar;
import java.util.Date;

public class InteractionEvent {
    private final Kind kind;
    private final Date date;
    private final Date endDate;
    private final String originId;
    private final String structureKind;
    private final String structureHandle;
    private final String navigation;
    private final String delta;
    private float interestContribution;
    public static final String ID_UNKNOWN = "?";

    public InteractionEvent(Kind kind, String structureKind, String handle, String originId) {
        this(kind, structureKind, handle, originId, 1.0f);
    }

    public InteractionEvent(Kind kind, String structureKind, String handle, String originId, String navigatedRelation) {
        this(kind, structureKind, handle, originId, navigatedRelation, "null", 1.0f);
    }

    public InteractionEvent(Kind kind, String structureKind, String handle, String originId, String navigatedRelation, float interestContribution) {
        this(kind, structureKind, handle, originId, navigatedRelation, "null", interestContribution);
    }

    public static InteractionEvent makeCommand(String originId, String delta) {
        return new InteractionEvent(Kind.COMMAND, "null", "null", originId, "null", delta, 1.0f);
    }

    public static InteractionEvent makeCopy(InteractionEvent originalEvent, float newInterestContribution) {
        return new InteractionEvent(originalEvent.getKind(), originalEvent.getStructureKind(), originalEvent.getStructureHandle(), originalEvent.getOriginId(), originalEvent.getNavigation(), originalEvent.getDelta(), newInterestContribution, originalEvent.getDate(), originalEvent.getEndDate());
    }

    public static InteractionEvent makePreference(String originId, String delta) {
        return new InteractionEvent(Kind.PREFERENCE, "null", "null", originId, "null", delta, 1.0f);
    }

    public InteractionEvent(Kind kind, String structureKind, String handle, String originId, float interestContribution) {
        this(kind, structureKind, handle, originId, "null", "null", interestContribution);
    }

    public InteractionEvent(Kind kind, String structureKind, String handle, String originId, String navigatedRelation, String delta, float interestContribution) {
        this.date = Calendar.getInstance().getTime();
        this.endDate = Calendar.getInstance().getTime();
        this.kind = kind;
        this.structureKind = structureKind;
        this.structureHandle = handle;
        this.originId = originId;
        this.navigation = navigatedRelation;
        this.delta = delta;
        this.interestContribution = interestContribution;
    }

    public InteractionEvent(Kind kind, String structureKind, String handle, String originId, String navigatedRelation, String delta, float interestContribution, Date startDate, Date endDate) {
        this.date = startDate;
        this.endDate = endDate;
        this.kind = kind;
        this.structureKind = structureKind;
        this.structureHandle = handle;
        this.originId = originId;
        this.navigation = navigatedRelation;
        this.delta = delta;
        this.interestContribution = interestContribution;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof InteractionEvent)) {
            return false;
        }
        InteractionEvent event = (InteractionEvent)object;
        return (this.date == null ? event.date == null : this.date.equals(event.date)) && (this.endDate == null ? event.endDate == null : this.endDate.equals(event.endDate)) && (this.kind == null ? event.kind == null : this.kind.equals((Object)event.kind)) && (this.structureKind == null ? event.structureKind == null : this.structureKind.equals(event.structureKind)) && (this.structureHandle == null ? event.structureHandle == null : this.structureHandle.equals(event.structureHandle)) && (this.originId == null ? event.originId == null : this.originId.equals(event.originId)) && (this.navigation == null ? event.navigation == null : this.navigation.equals(event.navigation)) && (this.delta == null ? event.delta == null : this.delta.equals(event.delta)) && this.interestContribution == event.interestContribution;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.date != null) {
            hashCode += this.date.hashCode();
        }
        if (this.endDate != null) {
            hashCode += this.endDate.hashCode();
        }
        if (this.kind != null) {
            hashCode += this.kind.hashCode();
        }
        if (this.structureKind != null) {
            hashCode += this.structureKind.hashCode();
        }
        if (this.structureHandle != null) {
            hashCode += this.structureHandle.hashCode();
        }
        if (this.originId != null) {
            hashCode += this.originId.hashCode();
        }
        if (this.navigation != null) {
            hashCode += this.navigation.hashCode();
        }
        if (this.delta != null) {
            hashCode += this.delta.hashCode();
        }
        return hashCode += new Float(this.interestContribution).hashCode();
    }

    public String toString() {
        return "(date: " + this.date + ", kind: " + (Object)((Object)this.kind) + ", sourceHandle: " + this.structureHandle + ", origin: " + this.originId + ", delta: " + this.delta + ")";
    }

    public boolean isValidStructureHandle() {
        return this.structureHandle != null && !this.structureHandle.equals("null") && !this.structureHandle.trim().equals(ID_UNKNOWN);
    }

    public String getStructureHandle() {
        return this.structureHandle;
    }

    public String getStructureKind() {
        return this.structureKind;
    }

    public Date getDate() {
        return this.date;
    }

    public String getDelta() {
        return this.delta;
    }

    public Kind getKind() {
        return this.kind;
    }

    public String getOriginId() {
        return this.originId;
    }

    public float getInterestContribution() {
        return this.interestContribution;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public String getNavigation() {
        return this.navigation;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        SELECTION,
        EDIT,
        COMMAND,
        PREFERENCE,
        PREDICTION,
        PROPAGATION,
        MANIPULATION;


        public boolean isUserEvent() {
            return this == SELECTION || this == EDIT || this == COMMAND || this == PREFERENCE;
        }

        public String toString() {
            switch (this) {
                case SELECTION: {
                    return "selection";
                }
                case EDIT: {
                    return "edit";
                }
                case COMMAND: {
                    return "command";
                }
                case PREFERENCE: {
                    return "preference";
                }
                case PREDICTION: {
                    return "prediction";
                }
                case PROPAGATION: {
                    return "propagation";
                }
                case MANIPULATION: {
                    return "manipulation";
                }
            }
            return "null";
        }

        public static Kind fromString(String string) {
            if (string == null) {
                return null;
            }
            if (string.equals("selection")) {
                return SELECTION;
            }
            if (string.equals("edit")) {
                return EDIT;
            }
            if (string.equals("command")) {
                return COMMAND;
            }
            if (string.equals("preference")) {
                return PREFERENCE;
            }
            if (string.equals("prediction")) {
                return PREDICTION;
            }
            if (string.equals("propagation")) {
                return PROPAGATION;
            }
            if (string.equals("manipulation")) {
                return MANIPULATION;
            }
            return null;
        }
    }
}

