/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.monitor.core.collection;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.mylar.internal.monitor.core.collection.IUsageCollector;
import org.eclipse.mylar.monitor.core.InteractionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SummaryCollector
implements IUsageCollector {
    protected int numSelections = 0;
    protected int numEdits = 0;
    protected int numUserEvents = 0;
    protected Date leastRecentDate = new Date();
    protected Date mostRecentDate = new Date(0L);
    protected int numCommands = 0;
    protected int numPreference = 0;

    @Override
    public void consumeEvent(InteractionEvent event, int userId) {
        if (this.mostRecentDate.compareTo(event.getDate()) == -1) {
            this.mostRecentDate = event.getDate();
        }
        if (this.leastRecentDate.compareTo(event.getDate()) == 1) {
            this.leastRecentDate = event.getDate();
        }
        if (event.getKind().equals((Object)InteractionEvent.Kind.SELECTION)) {
            ++this.numSelections;
        } else if (event.getKind().equals((Object)InteractionEvent.Kind.EDIT)) {
            ++this.numEdits;
        } else if (event.getKind().equals((Object)InteractionEvent.Kind.COMMAND)) {
            ++this.numCommands;
        } else if (event.getKind().equals((Object)InteractionEvent.Kind.PREFERENCE)) {
            ++this.numPreference;
        }
        ++this.numUserEvents;
    }

    @Override
    public List<String> getReport() {
        ArrayList<String> summaries = new ArrayList<String>();
        summaries.add("Start date: " + this.leastRecentDate + ", End date: " + this.mostRecentDate + "<br>");
        summaries.add("Number of events: " + this.numUserEvents + "<br>");
        summaries.add("Number of commands: " + this.numCommands + "<br>");
        summaries.add("Number of preference changes: " + this.numPreference + "<br>");
        summaries.add("Number of selections: " + this.numSelections + "<br>");
        return summaries;
    }

    @Override
    public String getReportTitle() {
        return "Summary";
    }

    @Override
    public void exportAsCSVFile(String directory) {
    }

    @Override
    public List<String> getPlainTextReport() {
        ArrayList<String> summaries = new ArrayList<String>();
        summaries.add("Start date: " + this.leastRecentDate + ", End date: " + this.mostRecentDate);
        summaries.add("Number of events: " + this.numUserEvents);
        summaries.add("Number of commands: " + this.numCommands);
        summaries.add("Number of preference changes: " + this.numPreference);
        summaries.add("Number of selections: " + this.numSelections);
        return summaries;
    }
}

