/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.monitor.usage;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mylar.internal.monitor.core.collection.InteractionEventSummary;

public class InteractionEventSummarySorter
extends ViewerSorter {
    public static final int TYPE = 1;
    public static final int ID = 2;
    public static final int NAME = 3;
    public static final int USAGE_COUNT = 4;
    private int criteria;

    public InteractionEventSummarySorter(int criteria) {
        this.criteria = criteria;
    }

    public int compare(Viewer viewer, Object obj1, Object obj2) {
        InteractionEventSummary summary1 = (InteractionEventSummary)obj1;
        InteractionEventSummary summary2 = (InteractionEventSummary)obj2;
        switch (this.criteria) {
            case 1: {
                return this.compareTypes(summary1, summary2);
            }
            case 3: {
                return this.compareNames(summary1, summary2);
            }
            case 4: {
                return this.compareUsageCount(summary2, summary1);
            }
        }
        return 0;
    }

    private int compareUsageCount(InteractionEventSummary summary1, InteractionEventSummary summary2) {
        int result = summary1.getUsageCount() - summary2.getUsageCount();
        result = result < 0 ? -1 : (result > 0 ? 1 : 0);
        return result;
    }

    protected int compareNames(InteractionEventSummary summary1, InteractionEventSummary summary2) {
        return this.getComparator().compare(summary1.getName(), summary2.getName());
    }

    protected int compareTypes(InteractionEventSummary summary1, InteractionEventSummary summary2) {
        return this.getComparator().compare(summary1.getType(), summary2.getType());
    }

    public int getCriteria() {
        return this.criteria;
    }
}

