/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.monitor.usage;

import java.io.File;
import java.io.IOException;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.httpclient.HttpClient;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylar.context.core.ContextCorePlugin;
import org.eclipse.mylar.context.core.IContextStoreListener;
import org.eclipse.mylar.core.MylarStatusHandler;
import org.eclipse.mylar.core.net.WebClientUtil;
import org.eclipse.mylar.internal.monitor.usage.InteractionEventLogger;
import org.eclipse.mylar.internal.monitor.usage.StudyParameters;
import org.eclipse.mylar.internal.monitor.usage.wizards.NewUsageSummaryEditorWizard;
import org.eclipse.mylar.monitor.core.IInteractionEventListener;
import org.eclipse.mylar.monitor.ui.AbstractCommandMonitor;
import org.eclipse.mylar.monitor.ui.IActionExecutionListener;
import org.eclipse.mylar.monitor.ui.IMylarMonitorLifecycleListener;
import org.eclipse.mylar.monitor.ui.MylarMonitorUiPlugin;
import org.eclipse.mylar.monitor.ui.workbench.ActionExecutionMonitor;
import org.eclipse.mylar.monitor.ui.workbench.ActivityChangeMonitor;
import org.eclipse.mylar.monitor.ui.workbench.KeybindingCommandMonitor;
import org.eclipse.mylar.monitor.ui.workbench.MenuCommandMonitor;
import org.eclipse.mylar.monitor.ui.workbench.PerspectiveChangeMonitor;
import org.eclipse.mylar.monitor.ui.workbench.PreferenceChangeMonitor;
import org.eclipse.mylar.monitor.ui.workbench.WindowChangeMonitor;
import org.eclipse.mylar.monitor.usage.IBackgroundPage;
import org.eclipse.mylar.monitor.usage.IQuestionnairePage;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivityManagerListener;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.update.internal.ui.security.Authentication;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MylarUsageMonitorPlugin
extends AbstractUIPlugin
implements IStartup {
    public static final String PREF_USER_ID = "org.eclipse.mylar.user.id";
    public static String VERSION = "1.0";
    public static String UPLOAD_FILE_LABEL = "USAGE";
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    private static final long DELAY_ON_USER_REQUEST = 432000000L;
    public static final String DEFAULT_TITLE = "Mylar Feedback";
    public static final String DEFAULT_DESCRIPTION = "Fill out the following form to help us improve Mylar based on your input.\n";
    public static final long DEFAULT_DELAY_BETWEEN_TRANSMITS = 1814400000L;
    public static final String DEFAULT_ETHICS_FORM = "doc/study-ethics.html";
    public static final String DEFAULT_VERSION = "";
    public static final String DEFAULT_UPLOAD_SERVER = "http://mylar.eclipse.org/monitor/upload";
    public static final String DEFAULT_UPLOAD_SERVLET_ID = "/GetUserIDServlet";
    public static final String DEFAULT_UPLOAD_SERVLET = "/MylarUsageUploadServlet";
    public static final String DEFAULT_ACCEPTED_URL_LIST = "";
    public static final String DEFAULT_CONTACT_CONSENT_FIELD = "false";
    public static final String UI_PLUGIN_ID = "org.eclipse.mylar.ui";
    public static final String MONITOR_LOG_NAME = "monitor-log";
    public static final String PLUGIN_ID = "org.eclipse.mylar.monitor.usage";
    private InteractionEventLogger interactionLogger;
    private String customizingPlugin = null;
    private PreferenceChangeMonitor preferenceMonitor = new PreferenceChangeMonitor();
    private PerspectiveChangeMonitor perspectiveMonitor;
    private ActivityChangeMonitor activityMonitor;
    private MenuCommandMonitor menuMonitor;
    private WindowChangeMonitor windowMonitor;
    private KeybindingCommandMonitor keybindingCommandMonitor;
    private static MylarUsageMonitorPlugin plugin;
    private List<IActionExecutionListener> actionExecutionListeners = new ArrayList<IActionExecutionListener>();
    private List<AbstractCommandMonitor> commandMonitors = new ArrayList<AbstractCommandMonitor>();
    private ResourceBundle resourceBundle;
    private static Date lastTransmit;
    private Authentication uploadAuthentication = null;
    private static boolean performingUpload;
    private boolean questionnaireEnabled = true;
    private boolean backgroundEnabled = false;
    private StudyParameters studyParameters = new StudyParameters();
    private ListenerList lifecycleListeners = new ListenerList();
    private IWindowListener WINDOW_LISTENER = new IWindowListener(){

        public void windowActivated(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
            if (window.getShell() != null) {
                window.getShell().removeShellListener(MylarUsageMonitorPlugin.this.SHELL_LISTENER);
            }
        }

        public void windowOpened(IWorkbenchWindow window) {
            if (window.getShell() != null && !PlatformUI.getWorkbench().isClosing()) {
                window.getShell().addShellListener(MylarUsageMonitorPlugin.this.SHELL_LISTENER);
            }
        }
    };
    private ShellListener SHELL_LISTENER = new ShellListener(){

        public void shellDeactivated(ShellEvent arg0) {
            if (!MylarUsageMonitorPlugin.isPerformingUpload() && ContextCorePlugin.getDefault() != null) {
                for (IInteractionEventListener listener : MylarMonitorUiPlugin.getDefault().getInteractionListeners()) {
                    listener.stopMonitoring();
                }
            }
        }

        public void shellActivated(ShellEvent arg0) {
            if (!ContextCorePlugin.getDefault().suppressWizardsOnStartup() && ContextCorePlugin.getDefault() != null) {
                MylarUsageMonitorPlugin.this.checkForStatisticsUpload();
            }
            if (!MylarUsageMonitorPlugin.isPerformingUpload() && ContextCorePlugin.getDefault() != null) {
                for (IInteractionEventListener listener : MylarMonitorUiPlugin.getDefault().getInteractionListeners()) {
                    listener.startMonitoring();
                }
            }
        }

        public void shellDeiconified(ShellEvent arg0) {
        }

        public void shellIconified(ShellEvent arg0) {
        }

        public void shellClosed(ShellEvent arg0) {
        }
    };
    private IContextStoreListener DATA_DIR_MOVE_LISTENER = new IContextStoreListener(){

        public void contextStoreMoved() {
            if (!MylarUsageMonitorPlugin.isPerformingUpload()) {
                for (IInteractionEventListener listener : MylarMonitorUiPlugin.getDefault().getInteractionListeners()) {
                    listener.stopMonitoring();
                }
                MylarUsageMonitorPlugin.this.interactionLogger.moveOutputFile(MylarUsageMonitorPlugin.this.getMonitorLogFile().getAbsolutePath());
                for (IInteractionEventListener listener : MylarMonitorUiPlugin.getDefault().getInteractionListeners()) {
                    listener.startMonitoring();
                }
            }
        }
    };

    static {
        lastTransmit = null;
        performingUpload = false;
    }

    public MylarUsageMonitorPlugin() {
        plugin = this;
    }

    private void initDefaultPrefs() {
        this.getPreferenceStore().setDefault("org.eclipse.mylar.monitor.ui.obfuscate", true);
        if (!this.getPreferenceStore().contains("org.eclipse.mylar.monitor.initially.enabled")) {
            this.getPreferenceStore().setValue("org.eclipse.mylar.monitor.initially.enabled", true);
            this.getPreferenceStore().setValue("org.eclipse.mylar.monitor.ui.enabled", true);
        }
        if (!this.getPreferenceStore().contains("org.eclipse.mylar.monitor.submission.initially.enabled")) {
            this.getPreferenceStore().setValue("org.eclipse.mylar.monitor.submission.initially.enabled", true);
            this.getPreferenceStore().setValue("org.eclipse.mylar.monitor.enable.submission", true);
        }
        this.getPreferenceStore().setValue("org.eclipse.mylar.monitor.monitoring.started", false);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.initDefaultPrefs();
        new MonitorUsageExtensionPointReader().initExtensions();
        try {
            this.interactionLogger = new InteractionEventLogger(this.getMonitorLogFile());
            this.perspectiveMonitor = new PerspectiveChangeMonitor();
            this.activityMonitor = new ActivityChangeMonitor();
            this.windowMonitor = new WindowChangeMonitor();
            this.menuMonitor = new MenuCommandMonitor();
            this.keybindingCommandMonitor = new KeybindingCommandMonitor();
            this.studyParameters.setServletUrl("http://mylar.eclipse.org/monitor/upload/MylarUsageUploadServlet");
            IWorkbench workbench = PlatformUI.getWorkbench();
            workbench.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    try {
                        if (MylarUsageMonitorPlugin.this.getPreferenceStore().getBoolean("org.eclipse.mylar.monitor.ui.enabled")) {
                            MylarUsageMonitorPlugin.this.startMonitoring();
                        }
                        if (plugin.getPreferenceStore().contains("org.eclipse.mylar.monitor.ui.upload.previousTransmit")) {
                            lastTransmit = new Date(plugin.getPreferenceStore().getLong("org.eclipse.mylar.monitor.ui.upload.previousTransmit"));
                        } else {
                            lastTransmit = new Date();
                            plugin.getPreferenceStore().setValue("org.eclipse.mylar.monitor.ui.upload.previousTransmit", lastTransmit.getTime());
                        }
                    }
                    catch (Throwable t) {
                        MylarStatusHandler.fail((Throwable)t, (String)"monitor failed to start", (boolean)false);
                    }
                }
            });
        }
        catch (Throwable t) {
            MylarStatusHandler.fail((Throwable)t, (String)"monitor failed to start", (boolean)false);
        }
    }

    public void earlyStartup() {
    }

    public void startMonitoring() {
        if (this.getPreferenceStore().contains("org.eclipse.mylar.monitor.monitoring.started")) {
            return;
        }
        this.interactionLogger.startMonitoring();
        for (IInteractionEventListener listener : MylarMonitorUiPlugin.getDefault().getInteractionListeners()) {
            listener.startMonitoring();
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        MylarMonitorUiPlugin.getDefault().addInteractionListener((IInteractionEventListener)this.interactionLogger);
        this.getCommandMonitors().add((AbstractCommandMonitor)this.keybindingCommandMonitor);
        this.getActionExecutionListeners().add((IActionExecutionListener)new ActionExecutionMonitor());
        workbench.addWindowListener(this.WINDOW_LISTENER);
        Object[] objectArray = workbench.getWorkbenchWindows();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow w = objectArray[n2];
            if (w.getShell() != null) {
                w.getShell().addShellListener(this.SHELL_LISTENER);
            }
            ++n2;
        }
        ContextCorePlugin.getDefault().getContextStore().addListener(this.DATA_DIR_MOVE_LISTENER);
        MylarMonitorUiPlugin.getDefault().addWindowPerspectiveListener((IPerspectiveListener)this.perspectiveMonitor);
        workbench.getActivitySupport().getActivityManager().addActivityManagerListener((IActivityManagerListener)this.activityMonitor);
        workbench.getDisplay().addFilter(13, (Listener)this.menuMonitor);
        workbench.addWindowListener((IWindowListener)this.windowMonitor);
        objectArray = this.lifecycleListeners.getListeners();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow listener = objectArray[n2];
            ((IMylarMonitorLifecycleListener)listener).startMonitoring();
            ++n2;
        }
        if (!ContextCorePlugin.getDefault().suppressWizardsOnStartup()) {
            this.checkForFirstMonitorUse();
        }
        this.getPreferenceStore().setValue("org.eclipse.mylar.monitor.monitoring.started", true);
    }

    public void addMonitoredPreferences(Preferences preferences) {
        preferences.addPropertyChangeListener((Preferences.IPropertyChangeListener)this.preferenceMonitor);
    }

    public void removeMonitoredPreferences(Preferences preferences) {
        preferences.removePropertyChangeListener((Preferences.IPropertyChangeListener)this.preferenceMonitor);
    }

    public boolean isObfuscationEnabled() {
        return MylarUsageMonitorPlugin.getPrefs().getBoolean("org.eclipse.mylar.monitor.ui.obfuscate");
    }

    public void stopMonitoring() {
        if (!this.getPreferenceStore().contains("org.eclipse.mylar.monitor.monitoring.started")) {
            return;
        }
        Object[] objectArray = this.lifecycleListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IMylarMonitorLifecycleListener)listener).stopMonitoring();
            ++n2;
        }
        for (Object listener : MylarMonitorUiPlugin.getDefault().getInteractionListeners()) {
            listener.stopMonitoring();
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        MylarMonitorUiPlugin.getDefault().removeInteractionListener((IInteractionEventListener)this.interactionLogger);
        this.getCommandMonitors().remove(this.keybindingCommandMonitor);
        this.getActionExecutionListeners().remove(new ActionExecutionMonitor());
        workbench.removeWindowListener(this.WINDOW_LISTENER);
        IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
        int n3 = iWorkbenchWindowArray.length;
        n = 0;
        while (n < n3) {
            IWorkbenchWindow w = iWorkbenchWindowArray[n];
            if (w.getShell() != null) {
                w.getShell().removeShellListener(this.SHELL_LISTENER);
            }
            ++n;
        }
        ContextCorePlugin.getDefault().getContextStore().removeListener(this.DATA_DIR_MOVE_LISTENER);
        MylarMonitorUiPlugin.getDefault().removeWindowPerspectiveListener((IPerspectiveListener)this.perspectiveMonitor);
        workbench.getActivitySupport().getActivityManager().removeActivityManagerListener((IActivityManagerListener)this.activityMonitor);
        workbench.getDisplay().removeFilter(13, (Listener)this.menuMonitor);
        workbench.removeWindowListener((IWindowListener)this.windowMonitor);
        this.interactionLogger.stopMonitoring();
        this.getPreferenceStore().setValue("org.eclipse.mylar.monitor.monitoring.started", false);
    }

    public void addMonitoringLifecycleListener(IMylarMonitorLifecycleListener listener) {
        this.lifecycleListeners.add((Object)listener);
        if (this.isMonitoringEnabled()) {
            listener.startMonitoring();
        }
    }

    public void removeMonitoringLifecycleListener(IMylarMonitorLifecycleListener listener) {
        this.lifecycleListeners.remove((Object)listener);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
        this.resourceBundle = null;
    }

    public void actionObserved(IAction action, String info) {
        for (IActionExecutionListener listener : this.actionExecutionListeners) {
            listener.actionObserved(action);
        }
    }

    public List<IActionExecutionListener> getActionExecutionListeners() {
        return this.actionExecutionListeners;
    }

    public List<AbstractCommandMonitor> getCommandMonitors() {
        return this.commandMonitors;
    }

    public File getMonitorLogFile() {
        File rootDir = ContextCorePlugin.getDefault().getContextStore() != null ? ContextCorePlugin.getDefault().getContextStore().getRootDirectory() : new File(this.getStateLocation().toString());
        File file = new File(rootDir, "monitor-log.xml");
        if (!file.exists() || !file.canWrite()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                MylarStatusHandler.log((Throwable)e, (String)"could not create monitor file");
            }
        }
        return file;
    }

    private long getUserPromptDelay() {
        return 5L;
    }

    public void userCancelSubmitFeedback(Date currentTime, boolean wait3Hours) {
        if (wait3Hours) {
            lastTransmit.setTime(currentTime.getTime() + 432000000L - this.studyParameters.getTransmitPromptPeriod());
            plugin.getPreferenceStore().setValue("org.eclipse.mylar.monitor.ui.upload.previousTransmit", lastTransmit.getTime());
        } else {
            long day = 86400000L;
            lastTransmit.setTime(currentTime.getTime() + day - this.studyParameters.getTransmitPromptPeriod());
            plugin.getPreferenceStore().setValue("org.eclipse.mylar.monitor.ui.upload.previousTransmit", lastTransmit.getTime());
        }
    }

    public static MylarUsageMonitorPlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = MylarUsageMonitorPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (this.resourceBundle == null) {
                this.resourceBundle = ResourceBundle.getBundle("org.eclipse.mylar.monitor.ui.MonitorPluginResources");
            }
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        return this.resourceBundle;
    }

    private void checkForFirstMonitorUse() {
    }

    private void checkForStatisticsUpload() {
        if (!this.isMonitoringEnabled()) {
            return;
        }
        if (plugin == null || plugin.getPreferenceStore() == null) {
            return;
        }
        if (plugin.getPreferenceStore().contains("org.eclipse.mylar.monitor.ui.upload.previousTransmit")) {
            lastTransmit = new Date(plugin.getPreferenceStore().getLong("org.eclipse.mylar.monitor.ui.upload.previousTransmit"));
        } else {
            lastTransmit = new Date();
            plugin.getPreferenceStore().setValue("org.eclipse.mylar.monitor.ui.upload.previousTransmit", lastTransmit.getTime());
        }
        Date currentTime = new Date();
        if (currentTime.getTime() > lastTransmit.getTime() + this.studyParameters.getTransmitPromptPeriod() && this.getPreferenceStore().getBoolean("org.eclipse.mylar.monitor.enable.submission")) {
            String ending = this.getUserPromptDelay() == 1L ? "" : "s";
            MessageDialog message = new MessageDialog(Display.getDefault().getActiveShell(), "Send Usage Feedback", null, "To help improve the Eclipse and Mylar user experience please consider uploading your UI usage statistics.", 3, new String[]{"Open UI Usage Report", "Remind me in " + this.getUserPromptDelay() + " day" + ending, "Don't ask again"}, 0);
            int result = 0;
            result = message.open();
            if (result == 0) {
                lastTransmit.setTime(new Date().getTime());
                plugin.getPreferenceStore().setValue("org.eclipse.mylar.monitor.ui.upload.previousTransmit", currentTime.getTime());
                if (!plugin.getPreferenceStore().contains("org.eclipse.mylar.monitor.mylar.eclipse.org.consent.viewed") || !plugin.getPreferenceStore().getBoolean("org.eclipse.mylar.monitor.mylar.eclipse.org.consent.viewed")) {
                    MessageDialog consentMessage = new MessageDialog(Display.getDefault().getActiveShell(), "Consent", null, "All data that is submitted to mylar.eclipse.org will be publicly available under the Eclipse Public License (EPL).  By submitting your data, you are agreeing that it can be publicly available. Please press cancel on the submission dialog box if you do not wish to share your data.", 2, new String[]{IDialogConstants.OK_LABEL}, 0);
                    consentMessage.open();
                    plugin.getPreferenceStore().setValue("org.eclipse.mylar.monitor.mylar.eclipse.org.consent.viewed", true);
                }
                NewUsageSummaryEditorWizard wizard = new NewUsageSummaryEditorWizard();
                wizard.init(PlatformUI.getWorkbench(), null);
                WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
                dialog.create();
                dialog.open();
            } else {
                if (result == 1) {
                    this.userCancelSubmitFeedback(currentTime, true);
                } else {
                    plugin.getPreferenceStore().setValue("org.eclipse.mylar.monitor.enable.submission", false);
                }
                message.close();
            }
        }
    }

    public void incrementObservedEvents(int increment) {
        int numEvents = this.getPreferenceStore().getInt("org.eclipse.mylar.monitor.ui.events.observed");
        this.getPreferenceStore().setValue("org.eclipse.mylar.monitor.ui.events.observed", numEvents += increment);
    }

    public void configureProxy(HttpClient httpClient, String uploadScript) {
        Proxy proxy = WebClientUtil.getPlatformProxy();
        WebClientUtil.setupHttpClient((HttpClient)httpClient, (Proxy)proxy, (String)uploadScript, (String)this.uploadAuthentication.getUser(), (String)this.uploadAuthentication.getPassword());
    }

    public static IPreferenceStore getPrefs() {
        return MylarUsageMonitorPlugin.getDefault().getPreferenceStore();
    }

    public static boolean isPerformingUpload() {
        return performingUpload;
    }

    public static void setPerformingUpload(boolean performingUpload) {
        MylarUsageMonitorPlugin.performingUpload = performingUpload;
    }

    public InteractionEventLogger getInteractionLogger() {
        return this.interactionLogger;
    }

    public boolean isQuestionnaireEnabled() {
        return this.questionnaireEnabled;
    }

    public void setQuestionnaireEnabled(boolean questionnaireEnabled) {
        this.questionnaireEnabled = questionnaireEnabled;
    }

    public StudyParameters getStudyParameters() {
        return this.studyParameters;
    }

    public String getCustomizingPlugin() {
        return this.customizingPlugin;
    }

    public boolean isMonitoringEnabled() {
        return this.getPreferenceStore().getBoolean("org.eclipse.mylar.monitor.ui.enabled");
    }

    public String getCustomizedByMessage() {
        String customizedBy = MylarUsageMonitorPlugin.getDefault().getCustomizingPlugin();
        String message = "NOTE: You have previously downloaded the Mylar monitor and a user study plug-in with id: " + customizedBy + "\n" + "If you are not familiar with this plug-in do not upload data.";
        return message;
    }

    public boolean isBackgroundEnabled() {
        return this.backgroundEnabled;
    }

    public void setBackgroundEnabled(boolean backgroundEnabled) {
        this.backgroundEnabled = backgroundEnabled;
    }

    public String getExtensionVersion() {
        return this.studyParameters.getVersion();
    }

    public boolean usingContactField() {
        return this.studyParameters.getUseContactField().equals("true");
    }

    class MonitorUsageExtensionPointReader {
        public static final String EXTENSION_ID_STUDY = "org.eclipse.mylar.monitor.ui.study";
        public static final String ELEMENT_SCRIPTS = "scripts";
        public static final String ELEMENT_SCRIPTS_VERSION = "version";
        public static final String ELEMENT_SCRIPTS_SERVER_URL = "url";
        public static final String ELEMENT_SCRIPTS_UPLOAD_USAGE = "upload";
        public static final String ELEMENT_SCRIPTS_GET_USER_ID = "userId";
        public static final String ELEMENT_SCRIPTS_UPLOAD_QUESTIONNAIRE = "questionnaire";
        public static final String ELEMENT_UI = "ui";
        public static final String ELEMENT_UI_TITLE = "title";
        public static final String ELEMENT_UI_DESCRIPTION = "description";
        public static final String ELEMENT_UI_UPLOAD_PROMPT = "daysBetweenUpload";
        public static final String ELEMENT_UI_QUESTIONNAIRE_PAGE = "questionnairePage";
        public static final String ELEMENT_UI_BACKGROUND_PAGE = "backgroundPage";
        public static final String ELEMENT_UI_CONSENT_FORM = "consentForm";
        public static final String ELEMENT_UI_CONTACT_CONSENT_FIELD = "useContactField";
        public static final String ELEMENT_MONITORS = "monitors";
        public static final String ELEMENT_MONITORS_BROWSER_URL = "browserUrlFilter";
        private boolean extensionsRead = false;

        MonitorUsageExtensionPointReader() {
        }

        public void initExtensions() {
            try {
                IExtensionRegistry registry;
                IExtensionPoint extensionPoint;
                if (!this.extensionsRead && (extensionPoint = (registry = Platform.getExtensionRegistry()).getExtensionPoint(EXTENSION_ID_STUDY)) != null) {
                    IExtension[] extensions = extensionPoint.getExtensions();
                    int i = 0;
                    while (i < extensions.length) {
                        IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                        int j = 0;
                        while (j < elements.length) {
                            if (elements[j].getName().compareTo(ELEMENT_SCRIPTS) == 0) {
                                this.readScripts(elements[j]);
                            } else if (elements[j].getName().compareTo(ELEMENT_UI) == 0) {
                                this.readForms(elements[j]);
                            } else if (elements[j].getName().compareTo(ELEMENT_MONITORS) == 0) {
                                this.readMonitors(elements[j]);
                            }
                            ++j;
                        }
                        MylarUsageMonitorPlugin.this.customizingPlugin = extensions[i].getNamespace();
                        ++i;
                    }
                    this.extensionsRead = true;
                }
            }
            catch (Throwable t) {
                MylarStatusHandler.fail((Throwable)t, (String)"could not read monitor extension", (boolean)false);
            }
        }

        private void readScripts(IConfigurationElement element) {
            MylarUsageMonitorPlugin.this.studyParameters.setVersion(element.getAttribute(ELEMENT_SCRIPTS_VERSION));
        }

        private void readForms(IConfigurationElement element) throws CoreException {
            Object page;
            MylarUsageMonitorPlugin.this.studyParameters.setTitle(element.getAttribute(ELEMENT_UI_TITLE));
            MylarUsageMonitorPlugin.this.studyParameters.setDescription(element.getAttribute(ELEMENT_UI_DESCRIPTION));
            if (element.getAttribute(ELEMENT_UI_UPLOAD_PROMPT) != null) {
                Integer uploadInt = new Integer(element.getAttribute(ELEMENT_UI_UPLOAD_PROMPT));
                MylarUsageMonitorPlugin.this.studyParameters.setTransmitPromptPeriod(86400000L * (long)uploadInt.intValue());
            }
            MylarUsageMonitorPlugin.this.studyParameters.setUseContactField(element.getAttribute(ELEMENT_UI_CONTACT_CONSENT_FIELD));
            try {
                if (element.getAttribute(ELEMENT_UI_QUESTIONNAIRE_PAGE) != null) {
                    Object questionnaireObject = element.createExecutableExtension(ELEMENT_UI_QUESTIONNAIRE_PAGE);
                    if (questionnaireObject instanceof IQuestionnairePage) {
                        page = (IQuestionnairePage)questionnaireObject;
                        MylarUsageMonitorPlugin.this.studyParameters.setQuestionnairePage((IQuestionnairePage)page);
                    }
                } else {
                    MylarUsageMonitorPlugin.getDefault().setQuestionnaireEnabled(false);
                }
            }
            catch (CoreException throwable) {
                MylarStatusHandler.fail((Throwable)throwable, (String)"could not load questionnaire", (boolean)false);
                MylarUsageMonitorPlugin.getDefault().setQuestionnaireEnabled(false);
            }
            try {
                if (element.getAttribute(ELEMENT_UI_BACKGROUND_PAGE) != null) {
                    Object backgroundObject = element.createExecutableExtension(ELEMENT_UI_BACKGROUND_PAGE);
                    if (backgroundObject instanceof IBackgroundPage) {
                        page = (IBackgroundPage)backgroundObject;
                        MylarUsageMonitorPlugin.this.studyParameters.setBackgroundPage((IBackgroundPage)page);
                        MylarUsageMonitorPlugin.getDefault().setBackgroundEnabled(true);
                    }
                } else {
                    MylarUsageMonitorPlugin.getDefault().setBackgroundEnabled(false);
                }
            }
            catch (CoreException throwable) {
                MylarStatusHandler.fail((Throwable)throwable, (String)"could not load background page", (boolean)false);
                MylarUsageMonitorPlugin.getDefault().setBackgroundEnabled(false);
            }
            MylarUsageMonitorPlugin.this.studyParameters.setFormsConsent("/" + element.getAttribute(ELEMENT_UI_CONSENT_FORM));
        }

        private void readMonitors(IConfigurationElement element) throws CoreException {
            String urlList = element.getAttribute(ELEMENT_MONITORS_BROWSER_URL);
            MylarUsageMonitorPlugin.this.studyParameters.setAcceptedUrlList(urlList);
        }
    }
}

