/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.monitor.usage;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylar.internal.monitor.usage.MylarUsageMonitorPlugin;
import org.eclipse.swt.graphics.Image;

public class UsageMonitorImages {
    private static Map<ImageDescriptor, Image> imageMap = new HashMap<ImageDescriptor, Image>();
    private static final String T_ELCL = "elcl16";
    private static final String T_EVIEW = "eview16";
    private static final URL baseURL = MylarUsageMonitorPlugin.getDefault().getBundle().getEntry("/icons/");
    public static final ImageDescriptor REFRESH = UsageMonitorImages.create("elcl16", "refresh.gif");
    public static final ImageDescriptor SYNCHED = UsageMonitorImages.create("elcl16", "synched.gif");
    public static final ImageDescriptor REMOVE = UsageMonitorImages.create("elcl16", "remove.gif");
    public static final ImageDescriptor MONITOR = UsageMonitorImages.create("eview16", "monitor.gif");
    public static final ImageDescriptor ZIP_FILE = UsageMonitorImages.create("elcl16", "import-zip.gif");

    private static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)UsageMonitorImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (baseURL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append('/');
        buffer.append(name);
        return new URL(baseURL, buffer.toString());
    }

    public static Image getImage(ImageDescriptor imageDescriptor) {
        Image image = imageMap.get(imageDescriptor);
        if (image == null) {
            image = imageDescriptor.createImage();
            imageMap.put(imageDescriptor, image);
        }
        return image;
    }
}

