/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.monitor.usage.collectors;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.mylar.internal.monitor.core.collection.IUsageCollector;
import org.eclipse.mylar.internal.monitor.core.collection.PercentUsageComparator;
import org.eclipse.mylar.monitor.core.InteractionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerspectiveUsageCollector
implements IUsageCollector {
    private Map<String, Integer> perspectiveUsage = new HashMap<String, Integer>();
    private String currentPerspective = "";
    private int numUnassociatedEvents = 0;
    private int numEvents = 0;

    public void consumeEvent(InteractionEvent event, int userId) {
        ++this.numEvents;
        if (event.getKind().equals((Object)InteractionEvent.Kind.PREFERENCE) && event.getDelta().equals("perspective activated")) {
            this.currentPerspective = event.getOriginId();
            if (!this.perspectiveUsage.containsKey(event.getOriginId())) {
                this.perspectiveUsage.put(event.getOriginId(), 1);
            }
        }
        if (!this.perspectiveUsage.containsKey(this.currentPerspective)) {
            ++this.numUnassociatedEvents;
            return;
        }
        this.perspectiveUsage.put(this.currentPerspective, this.perspectiveUsage.get(this.currentPerspective) + 1);
    }

    public List<String> getReport() {
        return this.getReport(true);
    }

    public String getReportTitle() {
        return "Perspective Usage";
    }

    public void exportAsCSVFile(String directory) {
        String filename = String.valueOf(directory) + File.separator + "PerspectiveUsage.csv";
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(new File(filename)));
            writer.write("Perspective");
            writer.write(",");
            writer.write("Events");
            writer.newLine();
            for (String perspective : this.perspectiveUsage.keySet()) {
                writer.write(perspective);
                writer.write(",");
                writer.write(new Integer(this.perspectiveUsage.get(perspective)).toString());
                writer.newLine();
            }
            writer.write("Unclassified");
            writer.write(",");
            writer.write(this.numUnassociatedEvents);
            writer.newLine();
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            System.err.println("Unable to write CVS file <" + filename + ">");
            e.printStackTrace(System.err);
        }
    }

    public List<String> getPlainTextReport() {
        return this.getReport(false);
    }

    private List<String> getReport(boolean html) {
        ArrayList<String> summaries = new ArrayList<String>();
        summaries.add("Perspectives (based on total user events, with " + this.numUnassociatedEvents + " unclassified events)");
        summaries.add(" ");
        ArrayList<String> perspectiveUsageList = new ArrayList<String>();
        for (String perspective : this.perspectiveUsage.keySet()) {
            String perspectiveName;
            float perspectiveUse = 100 * this.perspectiveUsage.get(perspective) / this.numEvents;
            String formattedPerspectiveUse = "" + perspectiveUse;
            int indexOf2ndDecimal = formattedPerspectiveUse.indexOf(46) + 3;
            if (indexOf2ndDecimal <= formattedPerspectiveUse.length()) {
                formattedPerspectiveUse = formattedPerspectiveUse.substring(0, indexOf2ndDecimal);
            }
            if ((perspectiveName = perspective).contains("Perspective")) {
                perspectiveName = perspectiveName.substring(0, perspectiveName.indexOf("Perspective"));
            }
            perspectiveUsageList.add(String.valueOf(formattedPerspectiveUse) + "%: " + perspectiveName + " (" + this.perspectiveUsage.get(perspective) + ")");
        }
        Collections.sort(perspectiveUsageList, new PercentUsageComparator());
        for (String perspectiveUsageSummary : perspectiveUsageList) {
            if (html) {
                summaries.add("<br>" + perspectiveUsageSummary);
                continue;
            }
            summaries.add(perspectiveUsageSummary);
        }
        if (this.perspectiveUsage.size() % 2 != 0) {
            summaries.add(" ");
        }
        return summaries;
    }
}

