/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.monitor.usage.editors;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylar.core.MylarStatusHandler;
import org.eclipse.mylar.internal.monitor.core.collection.IUsageCollector;
import org.eclipse.mylar.internal.monitor.usage.editors.UsageStatsEditorInput;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.EditorPart;

public class UsageEditorPart
extends EditorPart {
    protected UsageStatsEditorInput editorInput;
    protected FormToolkit toolkit;
    protected ScrolledForm sForm;
    protected Composite editorComposite;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.editorInput = (UsageStatsEditorInput)input;
        this.setPartName(this.editorInput.getName());
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.sForm = this.toolkit.createScrolledForm(parent);
        this.sForm.getBody().setLayout((Layout)new GridLayout());
        this.editorComposite = this.sForm.getBody();
        this.sForm.setText("Usage Summary");
        this.toolkit.decorateFormHeading(this.sForm.getForm());
        this.createSummaryStatsSection(this.editorComposite, this.toolkit);
        this.addSections(this.editorComposite, this.toolkit);
        this.createActionSection(this.editorComposite, this.toolkit);
    }

    protected void addSections(Composite composite, FormToolkit toolkit) {
    }

    public void setFocus() {
    }

    protected void createActionSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 256);
        section.setText("Actions");
        section.setLayout((Layout)new GridLayout());
        section.setLayoutData((Object)new GridData(768));
        Composite container = toolkit.createComposite((Composite)section);
        section.setClient((Control)container);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        Button exportHtml = toolkit.createButton(container, "Export as HTML", 0x1000008);
        exportHtml.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UsageEditorPart.this.exportToHtml();
            }
        });
        Button export = toolkit.createButton(container, "Export as CSV Files", 0x1000008);
        export.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UsageEditorPart.this.exportToCSV();
            }
        });
    }

    protected void createSummaryStatsSection(Composite parent, FormToolkit toolkit) {
        for (IUsageCollector collector : this.editorInput.getReportGenerator().getLastParsedSummary().getCollectors()) {
            List summary = collector.getPlainTextReport();
            if (summary.isEmpty()) continue;
            Section summarySection = toolkit.createSection(parent, 258);
            summarySection.setText(collector.getReportTitle());
            summarySection.setLayout((Layout)new GridLayout());
            summarySection.setLayoutData((Object)new GridData(768));
            Composite summaryContainer = toolkit.createComposite((Composite)summarySection);
            summaryContainer.setLayout((Layout)new GridLayout());
            GridData data = new GridData(1808);
            data.horizontalSpan = 1;
            data.grabExcessHorizontalSpace = true;
            summaryContainer.setLayoutData((Object)data);
            summarySection.setClient((Control)summaryContainer);
            StyledText t = new StyledText(summaryContainer, 0);
            t.setEditable(false);
            for (String description : summary) {
                t.append(String.valueOf(description) + System.getProperty("line.separator"));
            }
        }
    }

    protected void exportToCSV() {
        try {
            DirectoryDialog dialog = new DirectoryDialog(this.getSite().getWorkbenchWindow().getShell());
            dialog.setText("Specify a directory for the CSV files");
            String directoryName = dialog.open();
            String filename = String.valueOf(directoryName) + File.separator + "Usage.csv";
            File outputFile = new File(filename);
            FileOutputStream outputStream = new FileOutputStream(outputFile, false);
            for (IUsageCollector collector : this.editorInput.getReportGenerator().getCollectors()) {
                collector.exportAsCSVFile(directoryName);
            }
            outputStream.flush();
            outputStream.close();
        }
        catch (SWTException swe) {
            MylarStatusHandler.log((Throwable)swe, (String)"unable to get directory name");
        }
        catch (FileNotFoundException e) {
            MylarStatusHandler.log((Throwable)e, (String)"could not resolve file");
        }
        catch (IOException e) {
            MylarStatusHandler.log((Throwable)e, (String)"could not write to file");
        }
    }

    protected void exportToHtml() {
        try {
            FileDialog dialog = new FileDialog(this.getSite().getWorkbenchWindow().getShell());
            dialog.setText("Specify a file name");
            dialog.setFilterExtensions(new String[]{"*.html", "*.*"});
            String filename = dialog.open();
            if (!filename.endsWith(".html")) {
                filename = String.valueOf(filename) + ".html";
            }
            File outputFile = new File(filename);
            BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile));
            writer.write("<html><head>");
            for (IUsageCollector collector : this.editorInput.getReportGenerator().getCollectors()) {
                writer.write("<h3>" + collector.getReportTitle() + "</h3>");
                for (String reportLine : collector.getReport()) {
                    writer.write(reportLine);
                }
                writer.write("<br><hr>");
            }
            writer.write("</body></html>");
            writer.close();
        }
        catch (FileNotFoundException e) {
            MylarStatusHandler.log((Throwable)e, (String)"could not resolve file");
        }
        catch (IOException e) {
            MylarStatusHandler.log((Throwable)e, (String)"could not write to file");
        }
    }
}

