/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.monitor.usage.preferences;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.mylar.internal.monitor.usage.MylarUsageMonitorPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class UsageDataPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String DESCRIPTION = "If enabled the Mylar monitor logs selections, edits, commands, and preference changes. If you would like to help improve the user experience by anonymously sharing non-private parts of this data, enable automatic feedback submission or submit your data via the Usage Summary Wizard.";
    private static final long DAYS_IN_MS = 86400000L;
    private Button enableMonitoring;
    private Button enableObfuscation;
    private Button enableSubmission;
    private Text logFileText;
    private Text uploadUrl;
    private Text submissionTime;

    public UsageDataPreferencePage() {
        this.setPreferenceStore(MylarUsageMonitorPlugin.getPrefs());
        this.setDescription(DESCRIPTION);
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        container.setLayout((Layout)layout);
        if (MylarUsageMonitorPlugin.getDefault().getCustomizingPlugin() != null) {
            Label label = new Label(parent, 0);
            label.setText(MylarUsageMonitorPlugin.getDefault().getCustomizedByMessage());
            label.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        }
        this.createLogFileSection(container);
        this.createUsageSection(container);
        this.updateEnablement();
        return container;
    }

    public void init(IWorkbench workbench) {
    }

    private void updateEnablement() {
        if (!this.enableMonitoring.getSelection()) {
            this.logFileText.setEnabled(false);
            this.enableSubmission.setEnabled(false);
            this.submissionTime.setEnabled(false);
        } else {
            this.logFileText.setEnabled(true);
            this.enableSubmission.setEnabled(true);
            if (!this.enableSubmission.getSelection()) {
                this.submissionTime.setEnabled(false);
            } else {
                this.submissionTime.setEnabled(true);
            }
        }
    }

    private void createLogFileSection(Composite parent) {
        Group group = new Group(parent, 16);
        group.setText("Monitoring");
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(768));
        this.enableMonitoring = new Button((Composite)group, 32);
        this.enableMonitoring.setText("Enable logging to: ");
        this.enableMonitoring.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylar.monitor.ui.enabled"));
        this.enableMonitoring.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UsageDataPreferencePage.this.updateEnablement();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        String logFilePath = MylarUsageMonitorPlugin.getDefault().getMonitorLogFile().getPath();
        logFilePath = logFilePath.replaceAll("\\\\", "/");
        this.logFileText = new Text((Composite)group, 2048);
        this.logFileText.setText(logFilePath);
        this.logFileText.setEditable(false);
        this.logFileText.setLayoutData((Object)new GridData(768));
        this.enableObfuscation = new Button((Composite)group, 32);
        this.enableObfuscation.setText("Obfuscate elements using: ");
        this.enableObfuscation.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylar.monitor.ui.obfuscate"));
        Label obfuscationLablel = new Label((Composite)group, 0);
        obfuscationLablel.setText("SHA message digest one-way hash");
    }

    private void createUsageSection(Composite parent) {
        Group group = new Group(parent, 16);
        group.setText("Usage Feedback");
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(768));
        Label label = new Label((Composite)group, 0);
        label.setText(" Upload URL: ");
        this.uploadUrl = new Text((Composite)group, 2048);
        this.uploadUrl.setEditable(false);
        this.uploadUrl.setLayoutData((Object)new GridData(768));
        this.uploadUrl.setText(MylarUsageMonitorPlugin.getDefault().getStudyParameters().getServletUrl());
        Label events = new Label((Composite)group, 0);
        events.setText(" Events since upload:");
        Label logged = new Label((Composite)group, 0);
        logged.setText("" + this.getPreferenceStore().getInt("org.eclipse.mylar.monitor.ui.events.observed"));
        Composite enableSubmissionComposite = new Composite((Composite)group, 0);
        GridLayout submissionGridLayout = new GridLayout(4, false);
        submissionGridLayout.marginWidth = 0;
        submissionGridLayout.marginHeight = 0;
        enableSubmissionComposite.setLayout((Layout)submissionGridLayout);
        this.enableSubmission = new Button(enableSubmissionComposite, 32);
        this.enableSubmission.setText("Enable submission every");
        this.enableSubmission.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylar.monitor.enable.submission"));
        this.enableSubmission.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UsageDataPreferencePage.this.updateEnablement();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.submissionTime = new Text(enableSubmissionComposite, 133120);
        GridData gridData = new GridData();
        gridData.widthHint = 15;
        this.submissionTime.setLayoutData((Object)gridData);
        long submissionFreq = 1814400000L;
        if (MylarUsageMonitorPlugin.getPrefs().contains("org.eclipse.mylar.monitor.submission.frequency")) {
            submissionFreq = MylarUsageMonitorPlugin.getPrefs().getLong("org.eclipse.mylar.monitor.submission.frequency");
        }
        long submissionFreqInDays = (long)((double)submissionFreq) / 86400000L;
        this.submissionTime.setText("" + submissionFreqInDays);
        this.submissionTime.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
            }
        });
        Label label2 = new Label(enableSubmissionComposite, 0);
        label2.setText("days");
    }

    public void performDefaults() {
        super.performDefaults();
        this.logFileText.setText(MylarUsageMonitorPlugin.getDefault().getMonitorLogFile().getPath());
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("org.eclipse.mylar.monitor.ui.obfuscate", this.enableObfuscation.getSelection());
        if (this.enableMonitoring.getSelection()) {
            MylarUsageMonitorPlugin.getDefault().startMonitoring();
        } else {
            MylarUsageMonitorPlugin.getDefault().stopMonitoring();
        }
        this.getPreferenceStore().setValue("org.eclipse.mylar.monitor.enable.submission", this.enableSubmission.getSelection());
        this.getPreferenceStore().setValue("org.eclipse.mylar.monitor.ui.enabled", this.enableMonitoring.getSelection());
        long transmitFrequency = 1814400000L;
        String submissionFrequency = this.submissionTime.getText();
        try {
            transmitFrequency = Integer.parseInt(submissionFrequency);
            transmitFrequency *= 86400000L;
        }
        catch (NumberFormatException numberFormatException) {}
        this.getPreferenceStore().setValue("org.eclipse.mylar.monitor.submission.frequency", transmitFrequency);
        MylarUsageMonitorPlugin.getDefault().getStudyParameters().setTransmitPromptPeriod(transmitFrequency);
        return true;
    }

    public boolean performCancel() {
        this.enableMonitoring.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylar.monitor.ui.enabled"));
        this.enableObfuscation.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylar.monitor.ui.obfuscate"));
        return true;
    }
}

