/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.monitor.usage.wizards;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylar.core.MylarStatusHandler;
import org.eclipse.mylar.internal.core.util.ZipFileUtil;
import org.eclipse.mylar.internal.monitor.usage.InteractionEventLogger;
import org.eclipse.mylar.internal.monitor.usage.MonitorFileRolloverJob;
import org.eclipse.mylar.internal.monitor.usage.MylarUsageMonitorPlugin;
import org.eclipse.mylar.internal.monitor.usage.wizards.UsageFileSelectionWizardPage;
import org.eclipse.mylar.internal.monitor.usage.wizards.UsageUploadWizardPage;
import org.eclipse.mylar.monitor.core.InteractionEvent;
import org.eclipse.mylar.monitor.usage.IBackgroundPage;
import org.eclipse.mylar.monitor.usage.IQuestionnairePage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class UsageSubmissionWizard
extends Wizard
implements INewWizard {
    public static final String LOG = "log";
    public static final String STATS = "usage";
    public static final String QUESTIONAIRE = "questionaire";
    public static final String BACKGROUND = "background";
    private static final String ORG_ECLIPSE_PREFIX = "org.eclipse.";
    public static final int HTTP_SERVLET_RESPONSE_SC_OK = 200;
    public static final int SIZE_OF_INT = 8;
    private boolean failed = false;
    private boolean displayBackgroundPage = false;
    private boolean displayFileSelectionPage = false;
    private int uid;
    private final File monitorFile = MylarUsageMonitorPlugin.getDefault().getMonitorLogFile();
    private static int processedFileCount = 1;
    private UsageUploadWizardPage uploadPage;
    private UsageFileSelectionWizardPage fileSelectionPage;
    private IQuestionnairePage questionnairePage;
    private IBackgroundPage backgroundPage;
    private boolean performUpload = true;
    private List<String> backupFilesToUpload;
    private File questionnaireFile = null;
    private File backgroundFile = null;
    private int status;
    private String resp;

    public UsageSubmissionWizard() {
        this.setTitles();
        this.init(true);
    }

    public UsageSubmissionWizard(boolean performUpload) {
        this.setTitles();
        this.init(performUpload);
    }

    private void setTitles() {
        super.setDefaultPageImageDescriptor(MylarUsageMonitorPlugin.imageDescriptorFromPlugin((String)"org.eclipse.mylar.monitor.usage", (String)"icons/wizban/banner-user.gif"));
        super.setWindowTitle("Mylar Feedback");
    }

    private void init(boolean performUpload) {
        Object page;
        this.performUpload = performUpload;
        this.setNeedsProgressMonitor(true);
        this.uid = MylarUsageMonitorPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.mylar.user.id");
        if (this.uid == 0 || this.uid == -1) {
            this.uid = this.getNewUid();
            MylarUsageMonitorPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylar.user.id", this.uid);
        }
        this.uploadPage = new UsageUploadWizardPage(this);
        this.fileSelectionPage = new UsageFileSelectionWizardPage("TODO, change this string");
        if (MylarUsageMonitorPlugin.getDefault().isBackgroundEnabled()) {
            this.backgroundPage = page = MylarUsageMonitorPlugin.getDefault().getStudyParameters().getBackgroundPage();
        }
        if (MylarUsageMonitorPlugin.getDefault().isQuestionnaireEnabled() && performUpload) {
            page = MylarUsageMonitorPlugin.getDefault().getStudyParameters().getQuestionnairePage();
            this.questionnairePage = page;
        }
        super.setForcePreviousAndNextButtons(true);
    }

    public boolean performFinish() {
        if (!this.performUpload) {
            return true;
        }
        if (MylarUsageMonitorPlugin.getDefault().isQuestionnaireEnabled() && this.performUpload && this.questionnairePage != null) {
            this.questionnaireFile = this.questionnairePage.createFeedbackFile();
        }
        if (MylarUsageMonitorPlugin.getDefault().isBackgroundEnabled() && this.performUpload && this.displayBackgroundPage && this.backgroundPage != null) {
            this.backgroundFile = this.backgroundPage.createFeedbackFile();
        }
        if (this.displayFileSelectionPage) {
            this.backupFilesToUpload = this.fileSelectionPage.getZipFilesSelected();
        }
        Job j = new Job("Upload User Statistics"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask("Uploading user statistics", 3);
                    UsageSubmissionWizard.this.performUpload(monitor);
                    monitor.done();
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    MylarStatusHandler.log((Throwable)e, (String)"Error uploading statistics");
                    return new Status(4, "org.eclipse.mylar.monitor.usage", 4, "Error uploading statistics", (Throwable)e);
                }
            }
        };
        j.setPriority(50);
        j.schedule();
        return true;
    }

    public void performUpload(IProgressMonitor monitor) {
        File zipFile;
        if (MylarUsageMonitorPlugin.getDefault().isBackgroundEnabled() && this.performUpload && this.backgroundFile != null) {
            this.upload(this.backgroundFile, BACKGROUND, monitor);
            if (this.failed) {
                this.failed = false;
            }
            if (this.backgroundFile.exists()) {
                this.backgroundFile.delete();
            }
        }
        if (MylarUsageMonitorPlugin.getDefault().isQuestionnaireEnabled() && this.performUpload && this.questionnaireFile != null) {
            this.upload(this.questionnaireFile, QUESTIONAIRE, monitor);
            if (this.failed) {
                this.failed = false;
            }
            if (this.questionnaireFile.exists()) {
                this.questionnaireFile.delete();
            }
        }
        if ((zipFile = this.zipFilesForUpload()) == null) {
            return;
        }
        this.upload(zipFile, STATS, monitor);
        if (zipFile.exists()) {
            zipFile.delete();
        }
        if (!this.failed) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Successful Upload", (String)"Your usage statistics have been successfully uploaded.\n Thank you for participating.");
                }
            });
        }
        MylarUsageMonitorPlugin.getDefault().getInteractionLogger().startMonitoring();
        MylarUsageMonitorPlugin.setPerformingUpload(false);
    }

    public boolean performCancel() {
        MylarUsageMonitorPlugin.getDefault().userCancelSubmitFeedback(new Date(), true);
        return true;
    }

    public boolean canFinish() {
        if (!this.performUpload) {
            return true;
        }
        return this.getContainer().getCurrentPage() == this.uploadPage || !this.performUpload;
    }

    public UsageUploadWizardPage getUploadPage() {
        return this.uploadPage;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        if (MylarUsageMonitorPlugin.getDefault().isQuestionnaireEnabled() && this.performUpload && this.questionnairePage != null) {
            this.addPage(this.questionnairePage);
        }
        if (this.performUpload) {
            if (UsageFileSelectionWizardPage.unsubmittedLogsExist()) {
                this.addPage((IWizardPage)this.fileSelectionPage);
                this.displayFileSelectionPage = true;
            }
            this.addPage((IWizardPage)this.uploadPage);
        }
    }

    public void addBackgroundPage() {
        if (MylarUsageMonitorPlugin.getDefault().isBackgroundEnabled() && this.backgroundPage != null) {
            this.addPage(this.backgroundPage);
            this.displayBackgroundPage = true;
        }
    }

    private void upload(File f, String type, IProgressMonitor monitor) {
        if (this.failed) {
            return;
        }
        int status = 0;
        try {
            String servletUrl = MylarUsageMonitorPlugin.getDefault().getStudyParameters().getServletUrl();
            PostMethod filePost = new PostMethod(servletUrl);
            Part[] parts = new Part[]{new FilePart("temp.txt", f)};
            filePost.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, filePost.getParams()));
            HttpClient client = new HttpClient();
            status = client.executeMethod((HttpMethod)filePost);
            filePost.releaseConnection();
        }
        catch (Exception e) {
            this.failed = true;
            if (e instanceof NoRouteToHostException || e instanceof UnknownHostException) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openError(null, (String)"Error Uploading", (String)"There was an error uploading the file: \nNo network connection.  Please try again later");
                    }
                });
            }
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError(null, (String)"Error Uploading", (String)("There was an error uploading the file: \n" + e.getClass().getCanonicalName()));
                }
            });
            MylarStatusHandler.log((Throwable)e, (String)"failed to upload");
        }
        monitor.worked(1);
        final String filedesc = f.getName();
        final int httpResponseStatus = status;
        if (status == 401) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError(null, (String)"Error Uploading", (String)("There was an error uploading the " + filedesc + ": \n" + "Your uid was incorrect: " + UsageSubmissionWizard.this.uid + "\n"));
                }
            });
        } else if (status == 407) {
            this.failed = true;
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError(null, (String)"Error Uploading", (String)"Could not upload because proxy server authentication failed.  Please check your proxy server settings.");
                }
            });
        } else if (status != 200) {
            this.failed = true;
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError(null, (String)"Error Uploading", (String)("There was an error uploading the " + filedesc + ": \n" + "HTTP Response Code " + httpResponseStatus + "\n" + "Please try again later"));
                }
            });
        }
    }

    public String getMonitorFileName() {
        return this.monitorFile.getAbsolutePath();
    }

    public int getExistingUid(String firstName, String lastName, String emailAddress, boolean anonymous) {
        if (this.failed) {
            return -1;
        }
        try {
            String url = String.valueOf(MylarUsageMonitorPlugin.getDefault().getStudyParameters().getServletUrl()) + MylarUsageMonitorPlugin.getDefault().getStudyParameters().getServletUrl();
            final GetMethod getUidMethod = new GetMethod(url);
            NameValuePair first = new NameValuePair("firstName", firstName);
            NameValuePair last = new NameValuePair("lastName", lastName);
            NameValuePair email = new NameValuePair("email", emailAddress);
            NameValuePair job = new NameValuePair("jobFunction", "");
            NameValuePair size = new NameValuePair("companySize", "");
            NameValuePair buisness = new NameValuePair("companyBuisness", "");
            NameValuePair contact = new NameValuePair("contact", "");
            NameValuePair anon = null;
            anon = anonymous ? new NameValuePair("anonymous", "true") : new NameValuePair("anonymous", "false");
            if (MylarUsageMonitorPlugin.getDefault().usingContactField()) {
                getUidMethod.setQueryString(new NameValuePair[]{first, last, email, job, size, buisness, anon, contact});
            } else {
                getUidMethod.setQueryString(new NameValuePair[]{first, last, email, job, size, buisness, anon});
            }
            final HttpClient client = new HttpClient();
            MylarUsageMonitorPlugin.getDefault().configureProxy(client, url);
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
            pmd.run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("Get User Id", 1);
                    try {
                        UsageSubmissionWizard.this.status = client.executeMethod((HttpMethod)getUidMethod);
                        UsageSubmissionWizard.this.resp = UsageSubmissionWizard.this.getData(getUidMethod.getResponseBodyAsStream());
                        getUidMethod.releaseConnection();
                    }
                    catch (Exception e) {
                        UsageSubmissionWizard.this.failed = true;
                        if (e instanceof NoRouteToHostException || e instanceof UnknownHostException) {
                            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    MessageDialog.openError(null, (String)"Error Uploading", (String)"There was an error getting a new user id: \nNo network connection.  Please try again later");
                                }
                            });
                        }
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                MessageDialog.openError(null, (String)"Error Uploading", (String)("There was an error getting a new user id: \n" + e.getClass().getCanonicalName() + e.getMessage()));
                            }
                        });
                        MylarStatusHandler.log((Throwable)e, (String)"error uploading");
                    }
                    monitor.worked(1);
                    monitor.done();
                }
            });
            if (this.status == 200) {
                this.resp = this.resp.substring(this.resp.indexOf(":") + 1).trim();
                this.uid = Integer.parseInt(this.resp);
                MylarUsageMonitorPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylar.user.id", this.uid);
                return this.uid;
            }
            this.failed = true;
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError(null, (String)"Error Getting User ID", (String)("There was an error getting a user id: \nHTTP Response Code " + UsageSubmissionWizard.this.status + "\n" + "Please try again later"));
                }
            });
        }
        catch (Exception e) {
            this.failed = true;
            if (e instanceof NoRouteToHostException || e instanceof UnknownHostException) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openError(null, (String)"Error Uploading", (String)"There was an error getting a new user id: \nNo network connection.  Please try again later");
                    }
                });
            }
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError(null, (String)"Error Uploading", (String)("There was an error getting a new user id: \n" + e.getClass().getCanonicalName()));
                }
            });
            MylarStatusHandler.log((Throwable)e, (String)"error uploading");
        }
        return -1;
    }

    public int getNewUid() {
        PostMethod filePost = new PostMethod("http://mylar.eclipse.org/monitor/upload/GetUserIDServlet");
        filePost.addParameter(new NameValuePair("MylarUserID", ""));
        HttpClient client = new HttpClient();
        int status = 0;
        try {
            status = client.executeMethod((HttpMethod)filePost);
            if (status == 200) {
                InputStream inputStream = filePost.getResponseBodyAsStream();
                byte[] buffer = new byte[8];
                int numBytesRead = inputStream.read(buffer);
                int uid = new Integer(new String(buffer, 0, numBytesRead));
                filePost.releaseConnection();
                return uid;
            }
            return -1;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int getNewUid(String firstName, String lastName, String emailAddress, boolean anonymous, String jobFunction, String companySize, String companyFunction, boolean contactEmail) {
        block9: {
            if (this.failed) {
                return -1;
            }
            this.addBackgroundPage();
            PostMethod filePost = new PostMethod("http://mylar.eclipse.org/monitor/upload/GetUserIDServlet");
            filePost.addParameter(new NameValuePair("MylarUserID", ""));
            HttpClient client = new HttpClient();
            int status = 0;
            try {
                status = client.executeMethod((HttpMethod)filePost);
                if (status == 202) {
                    InputStream inputStream = filePost.getResponseBodyAsStream();
                    byte[] buffer = new byte[8];
                    int numBytesRead = inputStream.read(buffer);
                    int uid = new Integer(new String(buffer, 0, numBytesRead));
                    filePost.releaseConnection();
                    return uid;
                }
                return -1;
            }
            catch (Exception exception) {
                try {
                    if (status == 200) {
                        this.resp = this.resp.substring(this.resp.indexOf(":") + 1).trim();
                        this.uid = Integer.parseInt(this.resp);
                        MylarUsageMonitorPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylar.user.id", this.uid);
                        return this.uid;
                    }
                    this.failed = true;
                    MessageDialog.openError(null, (String)"Error Getting User ID", (String)("There was an error getting a user id: \nHTTP Response Code " + status + "\n" + "Please try again later"));
                }
                catch (Exception e) {
                    this.failed = true;
                    if (e instanceof NoRouteToHostException || e instanceof UnknownHostException) {
                        MessageDialog.openError(null, (String)"Error Uploading", (String)"There was an error getting a new user id: \nNo network connection.  Please try again later");
                        break block9;
                    }
                    MessageDialog.openError(null, (String)"Error Uploading", (String)("There was an error getting a new user id: \n" + e.getClass().getCanonicalName()));
                    MylarStatusHandler.log((Throwable)e, (String)"error uploading");
                }
            }
        }
        return -1;
    }

    private String getData(InputStream i) {
        String s = "";
        String data = "";
        BufferedReader br = new BufferedReader(new InputStreamReader(i));
        try {
            while ((s = br.readLine()) != null) {
                data = String.valueOf(data) + s;
            }
        }
        catch (IOException e) {
            MylarStatusHandler.log((Throwable)e, (String)"error uploading");
        }
        return data;
    }

    public int getUid() {
        return this.uid;
    }

    public boolean failed() {
        return this.failed;
    }

    private File processMonitorFile(File monitorFile) {
        File processedFile = new File("processed-monitor-log" + processedFileCount++ + ".xml");
        InteractionEventLogger logger = new InteractionEventLogger(processedFile);
        logger.startMonitoring();
        List<InteractionEvent> eventList = logger.getHistoryFromFile(monitorFile);
        if (eventList.size() > 0) {
            for (InteractionEvent event : eventList) {
                if (!event.getOriginId().startsWith(ORG_ECLIPSE_PREFIX)) continue;
                logger.interactionObserved(event);
            }
        }
        return processedFile;
    }

    private void addToSubmittedLogFile(String fileName) {
        File submissionLogFile = new File(MonitorFileRolloverJob.getZippedMonitorFileDirPath(), "submittedUsageLogs.txt");
        try {
            FileWriter fileWriter = new FileWriter(submissionLogFile, true);
            fileWriter.append(String.valueOf(fileName) + "\n");
            fileWriter.flush();
            fileWriter.close();
        }
        catch (FileNotFoundException e) {
            MylarStatusHandler.log((Throwable)e, (String)"error unzipping backup monitor log files");
        }
        catch (IOException e) {
            MylarStatusHandler.log((Throwable)e, (String)"error unzipping backup monitor log files");
        }
    }

    private File zipFilesForUpload() {
        MylarUsageMonitorPlugin.setPerformingUpload(true);
        MylarUsageMonitorPlugin.getDefault().getInteractionLogger().stopMonitoring();
        ArrayList<File> files = new ArrayList<File>();
        File monitorFile = MylarUsageMonitorPlugin.getDefault().getMonitorLogFile();
        File fileToUpload = this.processMonitorFile(monitorFile);
        files.add(fileToUpload);
        if (this.displayFileSelectionPage && this.backupFilesToUpload.size() > 0) {
            for (String currFilePath : this.backupFilesToUpload) {
                File file = new File(MonitorFileRolloverJob.getZippedMonitorFileDirPath(), currFilePath);
                if (!file.exists()) continue;
                try {
                    List unzippedFiles = ZipFileUtil.unzipFiles((File)file, (String)System.getProperty("java.io.tmpdir"));
                    if (unzippedFiles.size() <= 0) continue;
                    for (File f : unzippedFiles) {
                        files.add(this.processMonitorFile(f));
                        this.addToSubmittedLogFile(currFilePath);
                    }
                }
                catch (FileNotFoundException e) {
                    MylarStatusHandler.log((Throwable)e, (String)"error unzipping backup monitor log files");
                }
                catch (IOException e) {
                    MylarStatusHandler.log((Throwable)e, (String)"error unzipping backup monitor log files");
                }
            }
        }
        MylarUsageMonitorPlugin.getDefault().getInteractionLogger().startMonitoring();
        try {
            File zipFile = File.createTempFile(String.valueOf(this.uid) + ".", ".zip");
            ZipFileUtil.createZipFile((File)zipFile, files);
            return zipFile;
        }
        catch (Exception e) {
            MylarStatusHandler.log((Throwable)e, (String)"error uploading");
            return null;
        }
    }
}

