/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.monitor.usage.wizards;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylar.internal.monitor.usage.MylarUsageMonitorPlugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class UsageSummaryEditorWizardPage
extends WizardPage
implements IWizardPage {
    private static final String TITLE = "Usage Summary and Submission";
    private static final String DESCRIPTION = "Summarizes usage and provides mechanism for uploading to eclipse.org \nserver for usage analysis. May take a lot of memory for large histories.";
    private Button perspectiveCheckbox = null;
    private Button viewCheckbox = null;

    public UsageSummaryEditorWizardPage() {
        super(TITLE);
        this.setTitle(TITLE);
        this.setDescription(DESCRIPTION);
        this.setImageDescriptor(MylarUsageMonitorPlugin.imageDescriptorFromPlugin((String)"org.eclipse.mylar.monitor.usage", (String)"icons/wizban/banner-user.gif"));
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 4);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 1;
        Label label = new Label(container, 16384);
        label.setText("This will run in the background because it may take a long time for large histories.\nThe editor will open when the summary has been generated.");
        this.createCheckboxes(container);
        this.setControl((Control)container);
    }

    private void createCheckboxes(Composite parent) {
        Group checkboxGroup = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        checkboxGroup.setLayout((Layout)layout);
        checkboxGroup.setLayoutData((Object)new GridData(768));
        checkboxGroup.setText("Show usage summaries for:");
        checkboxGroup.setFont(parent.getFont());
        this.perspectiveCheckbox = new Button((Composite)checkboxGroup, 540704);
        this.perspectiveCheckbox.setText("Use of perspectives");
        this.perspectiveCheckbox.setSelection(true);
        this.perspectiveCheckbox.addSelectionListener((SelectionListener)new CheckboxSelectionListener());
        this.viewCheckbox = new Button((Composite)checkboxGroup, 540704);
        this.viewCheckbox.setText("Use of views");
        this.viewCheckbox.setSelection(true);
        this.viewCheckbox.addSelectionListener((SelectionListener)new CheckboxSelectionListener());
    }

    public boolean includePerspective() {
        return this.perspectiveCheckbox.getSelection();
    }

    public boolean includeViews() {
        return this.viewCheckbox.getSelection();
    }

    private class CheckboxSelectionListener
    extends SelectionAdapter {
        private CheckboxSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (!UsageSummaryEditorWizardPage.this.perspectiveCheckbox.getSelection() && !UsageSummaryEditorWizardPage.this.viewCheckbox.getSelection()) {
                UsageSummaryEditorWizardPage.this.setPageComplete(false);
            } else {
                UsageSummaryEditorWizardPage.this.setPageComplete(true);
            }
        }
    }
}

