/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.monitor.usage;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.eclipse.core.internal.preferences.Base64;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.mylar.context.core.AbstractContextStructureBridge;
import org.eclipse.mylar.context.core.ContextCorePlugin;
import org.eclipse.mylar.core.MylarStatusHandler;

public class InteractionEventObfuscator {
    private static final char DELIM_PATH = '/';
    public static final String LABEL_FAILED_TO_OBFUSCATE = "<failed to obfuscate>";
    public static final String ENCRYPTION_ALGORITHM = "SHA";

    public String obfuscateHandle(String structureKind, String structureHandle) {
        Object adapter;
        if (structureHandle == null || structureHandle.equals("")) {
            return structureHandle;
        }
        StringBuilder obfuscated = new StringBuilder();
        AbstractContextStructureBridge bridge = ContextCorePlugin.getDefault().getStructureBridge(structureKind);
        Object object = bridge.getObjectForHandle(structureHandle);
        if (object instanceof IAdaptable && (adapter = ((IAdaptable)object).getAdapter(IResource.class)) instanceof IResource) {
            obfuscated.append(this.obfuscateResourcePath(((IResource)adapter).getFullPath()));
            obfuscated.append('/');
        }
        obfuscated.append(this.obfuscateString(structureHandle));
        return obfuscated.toString();
    }

    public String obfuscateString(String string) {
        String obfuscatedString = null;
        try {
            MessageDigest md = MessageDigest.getInstance(ENCRYPTION_ALGORITHM);
            md.update(string.getBytes());
            byte[] digest = md.digest();
            obfuscatedString = new String(Base64.encode((byte[])digest)).replace('/', '=');
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            MylarStatusHandler.log((String)"SHA not available", null);
            obfuscatedString = LABEL_FAILED_TO_OBFUSCATE;
        }
        return obfuscatedString;
    }

    public String obfuscateResourcePath(IPath path) {
        if (path == null) {
            return "";
        }
        StringBuffer obfuscatedPath = new StringBuffer();
        int i = 0;
        while (i < path.segmentCount()) {
            obfuscatedPath.append(this.obfuscateString(path.segments()[i]));
            if (i < path.segmentCount() - 1) {
                obfuscatedPath.append('/');
            }
            ++i;
        }
        return obfuscatedPath.toString();
    }
}

