/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.resources;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.mylar.context.core.ContextCorePlugin;
import org.eclipse.mylar.core.MylarStatusHandler;
import org.eclipse.mylar.internal.resources.preferences.MylarResourcesPreferenceInitializer;
import org.eclipse.mylar.monitor.core.InteractionEvent;
import org.eclipse.mylar.resources.MylarResourcesPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceChangeMonitor
implements IResourceChangeListener {
    private boolean enabled = true;

    public void resourceChanged(IResourceChangeEvent event) {
        if (!this.enabled || !ContextCorePlugin.getContextManager().isContextActive()) {
            return;
        }
        if (event.getType() != 1) {
            return;
        }
        final HashSet<IResource> addedResources = new HashSet<IResource>();
        final HashSet<IResource> changedResources = new HashSet<IResource>();
        final Set<String> excludedPatterns = MylarResourcesPreferenceInitializer.getExcludedResourcePatterns();
        IResourceDelta rootDelta = event.getDelta();
        IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) {
                IResourceDelta[] added = delta.getAffectedChildren(1);
                int i = 0;
                while (i < added.length) {
                    IResource resource = added[i].getResource();
                    if ((resource instanceof IFile || resource instanceof IFolder) && !ResourceChangeMonitor.this.isExcluded(resource.getProjectRelativePath(), excludedPatterns)) {
                        addedResources.add(resource);
                    }
                    ++i;
                }
                IResourceDelta[] changed = delta.getAffectedChildren(6);
                int i2 = 0;
                while (i2 < changed.length) {
                    IResource resource = changed[i2].getResource();
                    if (resource instanceof IFile) {
                        changedResources.add(resource);
                    }
                    ++i2;
                }
                return true;
            }
        };
        try {
            rootDelta.accept(visitor);
            MylarResourcesPlugin.getDefault().getInterestUpdater().addResourceToContext(changedResources, InteractionEvent.Kind.PREDICTION);
            MylarResourcesPlugin.getDefault().getInterestUpdater().addResourceToContext(addedResources, InteractionEvent.Kind.SELECTION);
        }
        catch (CoreException e) {
            MylarStatusHandler.log((Throwable)e, (String)"could not accept marker visitor");
        }
    }

    public boolean isExcluded(IPath path, Set<String> excludedPatterns) {
        if (path == null) {
            return false;
        }
        boolean excluded = false;
        for (String pattern : excludedPatterns) {
            String[] stringArray = path.segments();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String segment = stringArray[n2];
                boolean matches = segment.matches(pattern.replaceAll("\\.", "\\\\.").replaceAll("\\*", ".*"));
                if (matches) {
                    excluded = true;
                }
                ++n2;
            }
        }
        return excluded;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

