/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.resources.ui;

import org.eclipse.compare.internal.CompareEditor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.mylar.context.core.AbstractContextStructureBridge;
import org.eclipse.mylar.context.core.ContextCorePlugin;
import org.eclipse.mylar.context.core.IMylarElement;
import org.eclipse.mylar.context.ui.AbstractContextUiBridge;
import org.eclipse.mylar.context.ui.ContextUiPlugin;
import org.eclipse.mylar.internal.resources.ui.IContextAwareEditor;
import org.eclipse.mylar.monitor.core.InteractionEvent;
import org.eclipse.mylar.monitor.ui.workbench.AbstractEditorTracker;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.Workbench;

public class EditorInteractionMonitor
extends AbstractEditorTracker {
    public static final String SOURCE_ID = "org.eclipse.mylar.ide.editor.tracker.interest";

    protected void editorBroughtToTop(IEditorPart part) {
        Object object = part.getEditorInput().getAdapter(IResource.class);
        if (object instanceof IResource) {
            IResource resource = (IResource)object;
            AbstractContextStructureBridge bridge = ContextCorePlugin.getDefault().getStructureBridge((Object)resource);
            InteractionEvent selectionEvent = new InteractionEvent(InteractionEvent.Kind.SELECTION, bridge.getContentType(), bridge.getHandleIdentifier((Object)resource), part.getSite().getId());
            ContextCorePlugin.getContextManager().handleInteractionEvent(selectionEvent);
        }
    }

    public void editorOpened(IEditorPart editorPartOpened) {
        IWorkbenchPage page = editorPartOpened.getSite().getPage();
        IEditorReference[] editorReferences = page.getEditorReferences();
        int i = 0;
        while (i < editorReferences.length) {
            IMylarElement element = null;
            IEditorPart editorToClose = editorReferences[i].getEditor(false);
            if (editorToClose != null) {
                Object adapter = editorToClose.getEditorInput().getAdapter(IResource.class);
                if (adapter instanceof IFile) {
                    String handle = ContextCorePlugin.getDefault().getStructureBridge(adapter).getHandleIdentifier(adapter);
                    element = ContextCorePlugin.getContextManager().getElement(handle);
                }
                if (!(ContextCorePlugin.getContextManager().isContextCapturePaused() || element == null || element.getInterest().isInteresting() || this.isSameEditor(editorPartOpened, editorToClose))) {
                    page.closeEditor(editorToClose, true);
                }
            }
            ++i;
        }
    }

    private boolean isSameEditor(IEditorPart editorPart1, IEditorPart editorPart2) {
        if (editorPart1 == null || editorPart2 == null) {
            return false;
        }
        return editorPart1.equals(editorPart2) && editorPart1.getEditorInput().equals(editorPart2.getEditorInput());
    }

    public void editorClosed(IEditorPart editorPart) {
        if (PlatformUI.getWorkbench().isClosing()) {
            return;
        }
        if (!(!ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylar.ide.ui.editors.auto.manage") || Workbench.getInstance().getPreferenceStore().getBoolean("REUSE_OPEN_EDITORS_BOOLEAN") || this.otherEditorsOpenForResource(editorPart) || editorPart instanceof CompareEditor || editorPart instanceof IContextAwareEditor)) {
            Object adapter;
            IMylarElement element = null;
            AbstractContextUiBridge uiBridge = ContextUiPlugin.getDefault().getUiBridgeForEditor(editorPart);
            Object object = uiBridge.getObjectForTextSelection(null, editorPart);
            if (object != null) {
                AbstractContextStructureBridge bridge = ContextCorePlugin.getDefault().getStructureBridge(object);
                element = ContextCorePlugin.getContextManager().getElement(bridge.getHandleIdentifier(object));
            }
            if (element == null && (adapter = editorPart.getEditorInput().getAdapter(IResource.class)) instanceof IResource) {
                IResource resource = (IResource)adapter;
                AbstractContextStructureBridge resourceBridge = ContextCorePlugin.getDefault().getStructureBridge((Object)resource);
                element = ContextCorePlugin.getContextManager().getElement(resourceBridge.getHandleIdentifier((Object)resource));
            }
            if (element != null) {
                ContextCorePlugin.getContextManager().manipulateInterestForElement(element, false, false, SOURCE_ID);
            }
        }
    }

    private boolean otherEditorsOpenForResource(IEditorPart editorPart) {
        Object adapter = editorPart.getEditorInput().getAdapter(IResource.class);
        if (adapter instanceof IResource) {
            IResource resource = (IResource)adapter;
            IWorkbenchPage page = editorPart.getSite().getPage();
            IEditorReference[] editorReferences = page.getEditorReferences();
            int i = 0;
            while (i < editorReferences.length) {
                Object otherAdapter;
                IEditorPart otherEditor = editorReferences[i].getEditor(false);
                if (otherEditor != null && (otherAdapter = otherEditor.getEditorInput().getAdapter(IResource.class)) instanceof IResource && otherAdapter.equals(resource)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

