/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.resources.ui;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.mylar.context.ui.InterestFilter;
import org.eclipse.mylar.internal.context.ui.actions.AbstractAutoFocusViewAction;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.extensions.LinkHelperService;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.ILinkHelper;

public abstract class FocusCommonNavigatorAction
extends AbstractAutoFocusViewAction {
    private LinkHelperService linkService;
    private CommonNavigator commonNavigator;

    public FocusCommonNavigatorAction(InterestFilter interestFilter, boolean manageViewer, boolean manageFilters, boolean manageLinking) {
        super(interestFilter, manageViewer, manageFilters, manageLinking);
    }

    protected ISelection resolveSelection(IEditorPart editor, ITextSelection changedSelection, StructuredViewer viewer) throws CoreException {
        if (this.commonNavigator == null) {
            this.commonNavigator = (CommonNavigator)super.getPartForAction();
        }
        if (this.linkService == null) {
            this.linkService = new LinkHelperService((NavigatorContentService)this.commonNavigator.getCommonViewer().getNavigatorContentService());
        }
        IEditorInput input = editor.getEditorInput();
        ILinkHelper[] helpers = this.linkService.getLinkHelpersFor(editor.getEditorInput());
        StructuredSelection selection = StructuredSelection.EMPTY;
        StructuredSelection newSelection = StructuredSelection.EMPTY;
        int i = 0;
        while (i < helpers.length) {
            selection = helpers[i].findSelection(input);
            if (selection != null && !selection.isEmpty()) {
                newSelection = this.mergeSelection((IStructuredSelection)newSelection, (IStructuredSelection)selection);
            }
            ++i;
        }
        if (!newSelection.isEmpty()) {
            return newSelection;
        }
        return null;
    }

    protected void select(StructuredViewer viewer, ISelection toSelect) {
        if (this.commonNavigator == null) {
            this.commonNavigator = (CommonNavigator)super.getPartForAction();
        }
        if (this.commonNavigator != null) {
            this.commonNavigator.selectReveal(toSelect);
        }
    }

    protected void setDefaultLinkingEnabled(boolean on) {
        IViewPart part = super.getPartForAction();
        if (part instanceof CommonNavigator) {
            ((CommonNavigator)part).setLinkingEnabled(on);
        }
    }

    protected boolean isDefaultLinkingEnabled() {
        IViewPart part = super.getPartForAction();
        if (part instanceof CommonNavigator) {
            return ((CommonNavigator)part).isLinkingEnabled();
        }
        return false;
    }

    private IStructuredSelection mergeSelection(IStructuredSelection aBase, IStructuredSelection aSelectionToAppend) {
        if (aBase == null || aBase.isEmpty()) {
            return aSelectionToAppend != null ? aSelectionToAppend : StructuredSelection.EMPTY;
        }
        if (aSelectionToAppend == null || aSelectionToAppend.isEmpty()) {
            return aBase;
        }
        ArrayList newItems = new ArrayList(aBase.toList());
        newItems.addAll(aSelectionToAppend.toList());
        return new StructuredSelection(newItems);
    }
}

