/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.resources.ui;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.mylar.context.core.AbstractContextStructureBridge;
import org.eclipse.mylar.context.core.ContextCorePlugin;
import org.eclipse.mylar.context.core.IMylarElement;
import org.eclipse.mylar.context.ui.AbstractContextUiBridge;
import org.eclipse.mylar.core.MylarStatusHandler;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUiBridge
extends AbstractContextUiBridge {
    public void open(IMylarElement element) {
        AbstractContextStructureBridge bridge = ContextCorePlugin.getDefault().getStructureBridge(element.getContentType());
        if (bridge == null) {
            return;
        }
        IResource resource = (IResource)bridge.getObjectForHandle(element.getHandleIdentifier());
        if (resource instanceof IFile && resource.exists()) {
            this.internalOpenEditor((IFile)resource, true);
        }
    }

    private void internalOpenEditor(IFile file, boolean activate) {
        try {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IEditorDescriptor editorDescriptor = IDE.getDefaultEditor((IFile)file);
            if (editorDescriptor != null && editorDescriptor.isInternal() && !editorDescriptor.isOpenInPlace() && !this.isContextIgnoring(editorDescriptor)) {
                IDE.openEditor((IWorkbenchPage)activePage, (IFile)file, (boolean)activate);
            }
        }
        catch (PartInitException e) {
            MylarStatusHandler.fail((Throwable)e, (String)("failed to open editor for: " + file), (boolean)false);
        }
    }

    private boolean isContextIgnoring(IEditorDescriptor editorDescriptor) {
        return editorDescriptor.getId() != null && editorDescriptor.getId().endsWith(".contextIgnoring");
    }

    public void close(IMylarElement element) {
        IWorkbenchPage page;
        AbstractContextStructureBridge bridge = ContextCorePlugin.getDefault().getStructureBridge(element.getContentType());
        Object object = bridge.getObjectForHandle(element.getHandleIdentifier());
        if (object instanceof IFile && (page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()) != null) {
            IEditorReference[] references = page.getEditorReferences();
            int i = 0;
            while (i < references.length) {
                Object adapter;
                IEditorInput input;
                IEditorPart editorPart = references[i].getEditor(false);
                if (editorPart != null && (input = editorPart.getEditorInput()) != null && (adapter = input.getAdapter(IResource.class)) instanceof IFile && ((IFile)adapter).equals(object)) {
                    page.closeEditor(references[i].getEditor(false), true);
                }
                ++i;
            }
        }
    }

    public boolean acceptsEditor(IEditorPart editorPart) {
        return false;
    }

    public List<TreeViewer> getContentOutlineViewers(IEditorPart editor) {
        return Collections.emptyList();
    }

    public Object getObjectForTextSelection(TextSelection selection, IEditorPart editor) {
        return null;
    }

    public IMylarElement getElement(IEditorInput input) {
        Object adapter = input.getAdapter(IResource.class);
        if (adapter instanceof IFile) {
            IFile javaElement = (IFile)adapter;
            String handle = ContextCorePlugin.getDefault().getStructureBridge((Object)javaElement).getHandleIdentifier((Object)javaElement);
            return ContextCorePlugin.getContextManager().getElement(handle);
        }
        return null;
    }

    public String getContentType() {
        return "*";
    }
}

